/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.batch.service.impl;

import com.humuson.tms.batch.domain.TargetSchedule;
import com.humuson.tms.batch.service.ScheduleService;
import com.humuson.tms.constrants.ChannelType;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public class TargetScheduleService
implements ScheduleService<TargetSchedule> {
    private static final Logger log = LoggerFactory.getLogger(TargetScheduleService.class);
    ConcurrentHashMap<String, Boolean> runningScheduleMap = new ConcurrentHashMap();
    private String selectSchedule;
    private String updateSchedule;
    private String selectIsCancleCount;
    @Autowired
    private JdbcTemplate jdbcTemplate;

    @Override
    public boolean isRunning(String key) {
        Boolean isRun = this.runningScheduleMap.get(key);
        if (isRun == null) {
            return false;
        }
        return isRun;
    }

    @Override
    public void setRunning(String id, boolean isRun) {
        this.runningScheduleMap.put(id, isRun);
    }

    @Override
    public List<TargetSchedule> getScheduleList(Object[] params) {
        return this.jdbcTemplate.query(this.selectSchedule, (RowMapper)new RowMapper<TargetSchedule>(){

            public TargetSchedule mapRow(ResultSet rs, int rowNum) throws SQLException {
                TargetSchedule schedule = new TargetSchedule();
                schedule.setPostId(rs.getString("POST_ID"));
                schedule.setChannelType(ChannelType.valueOfCode((String)rs.getString("CHN_TYPE")));
                schedule.setTargetType(rs.getString("TARGET_TYPE"));
                schedule.setMsgId(rs.getString("MSG_ID"));
                schedule.setDeduplicationYn(rs.getString("DEDUPLICATION_YN"));
                if (log.isDebugEnabled()) {
                    log.debug("target schedule : {}", (Object)schedule.toString());
                }
                return schedule;
            }
        }, params);
    }

    @Override
    public int updateScheduleStatus(String msgId, String status) {
        int cnt = this.jdbcTemplate.update(this.updateSchedule, new Object[]{status, msgId});
        log.info("update schedule status [msgId:{}, status:{}, uptCnt:{}]", new Object[]{msgId, status, cnt});
        return cnt;
    }

    @Override
    public List<TargetSchedule> getScheduleList() {
        return this.getScheduleList(new Object[0]);
    }

    @Override
    public boolean isCanceled(String key) {
        int count = (Integer)this.jdbcTemplate.queryForObject(this.selectIsCancleCount, new Object[]{key}, Integer.class);
        return count > 0;
    }

    public void setSelectSchedule(String selectSchedule) {
        this.selectSchedule = selectSchedule;
    }

    public void setUpdateSchedule(String updateSchedule) {
        this.updateSchedule = updateSchedule;
    }

    public void setSelectIsCancleCount(String selectIsCancleCount) {
        this.selectIsCancleCount = selectIsCancleCount;
    }
}

