/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.batch.service.impl;

import com.humuson.tms.batch.domain.PushUpdateSchedule;
import com.humuson.tms.batch.service.ScheduleService;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public class PushUpdateScheduleService
implements ScheduleService<PushUpdateSchedule> {
    private static final Logger log = LoggerFactory.getLogger(PushUpdateScheduleService.class);
    ConcurrentHashMap<String, Boolean> runningScheduleMap = new ConcurrentHashMap();
    private String selectSchedule;
    private String updateSchedule;
    @Autowired
    private JdbcTemplate jdbcTemplate;

    @Override
    public boolean isRunning(String key) {
        Boolean isRun = this.runningScheduleMap.get(key);
        if (isRun == null) {
            return false;
        }
        return isRun;
    }

    @Override
    public void setRunning(String id, boolean isRun) {
        this.runningScheduleMap.put(id, isRun);
    }

    @Override
    public List<PushUpdateSchedule> getScheduleList(Object[] params) {
        return this.jdbcTemplate.query(this.selectSchedule, (RowMapper)new RowMapper<PushUpdateSchedule>(){

            public PushUpdateSchedule mapRow(ResultSet rs, int rowNum) throws SQLException {
                PushUpdateSchedule schedule = new PushUpdateSchedule();
                schedule.setMaxId(rs.getLong("MAX_ID"));
                schedule.setMinId(rs.getLong("MIN_ID"));
                return schedule;
            }
        }, params);
    }

    @Override
    public int updateScheduleStatus(String key, String status) {
        log.info("updateScheduleStatus [key:{}, status:{}]", (Object)key, (Object)status);
        return 0;
    }

    @Override
    public List<PushUpdateSchedule> getScheduleList() {
        return this.getScheduleList(new Object[0]);
    }

    @Override
    public boolean isCanceled(String key) {
        return false;
    }

    public void setSelectSchedule(String selectSchedule) {
        this.selectSchedule = selectSchedule;
    }

    public void setUpdateSchedule(String updateSchedule) {
        this.updateSchedule = updateSchedule;
    }
}

