/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.batch.service.impl;

import com.google.android.gcm.server.Message;
import com.humuson.rainboots.proto.messages.PushProtos;
import com.humuson.tms.batch.domain.App;
import com.humuson.tms.batch.domain.PushMessage;
import com.humuson.tms.batch.domain.PushQueue;
import com.humuson.tms.batch.domain.PushResult;
import com.humuson.tms.batch.service.GcmHttpService;
import com.humuson.tms.batch.service.PrivatePushService;
import com.humuson.tms.batch.service.PushSendService;
import com.humuson.tms.batch.service.impl.GcmCcsService;
import com.humuson.tms.common.security.HumusonDecryptor;
import com.humuson.tms.common.security.SSLChecker;
import com.humuson.tms.common.util.FileUtil;
import com.humuson.tms.common.util.StringUtils;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javapns.devices.Device;
import javapns.devices.exceptions.InvalidDeviceTokenFormatException;
import javapns.devices.implementations.basic.BasicDevice;
import javapns.notification.AppleNotificationServer;
import javapns.notification.AppleNotificationServerBasicImpl;
import javapns.notification.Payload;
import javapns.notification.PushNotificationManager;
import javapns.notification.PushNotificationPayload;
import javapns.notification.PushedNotification;
import org.json.simple.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;

public class PushSendServiceImpl
implements PushSendService<List<? extends PushQueue>, List<PushResult>> {
    private static final Logger log = LoggerFactory.getLogger(PushSendServiceImpl.class);
    static final String HTTP_URL = "http://";
    protected static final String DEFAULT_SERVER_NAME = "TMS-SEND-01";
    protected static final String RAINBOOTS_RUN = "Y";
    static final int DEFAULT_PUSH_LIVE_TIME = 1800;
    protected PushNotificationManager pushManager;
    @Autowired
    protected PrivatePushService<PushProtos.PushResponse, PushProtos.PushRequest> privateService;
    protected App appInfo;
    @Value(value="#{config['tms.db.enc.key']}")
    protected String encKey;
    protected final String serverName;
    @Value(value="#{config['tms.private.qos.level']}")
    protected int privateQosLevel;
    @Value(value="#{config['tms.apns.production.cn']}")
    protected String productionCN;
    @Value(value="#{config['tms.apns.development.cn']}")
    protected String developmentCN;
    @Value(value="#{config['send.gcm.type']}")
    protected String gcmType;
    @Autowired
    protected GcmCcsService gcmCcsService;
    @Autowired
    @Qualifier(value="gcmHttpServiceImpl")
    protected GcmHttpService<PushResult, PushQueue> gcmHttpServiceImpl;
    protected Map<String, Boolean> denyAppVersionMap = new ConcurrentHashMap<String, Boolean>();

    public PushSendServiceImpl() {
        this.serverName = DEFAULT_SERVER_NAME;
        log.debug("PushSendServiceImpl :{} instance generate hashCode:{}", (Object)this.serverName, (Object)this.hashCode());
    }

    public PushSendServiceImpl(String serverName) {
        this.serverName = serverName;
        log.debug("PushSendServiceImpl :{} instance generate hashCode:{}", (Object)serverName, (Object)this.hashCode());
    }

    @Override
    public synchronized void init(App appInfo) {
        try {
            String[] denyAppVersions;
            this.appInfo = appInfo;
            for (String denyAppVer : denyAppVersions = appInfo.getDenyAppVersion().split(",")) {
                this.denyAppVersionMap.put(denyAppVer, true);
            }
            String apnsCert = appInfo.getApnsPushCert();
            String apnsPwd = appInfo.getApnsPushPwd();
            String gcmApiKey = appInfo.getGcmApiKey();
            long gcmProjectNum = appInfo.getGcmProjectNum();
            if (gcmApiKey != null && this.gcmType.equalsIgnoreCase("http")) {
                this.gcmHttpServiceImpl.init(appInfo);
            } else if (gcmApiKey != null && this.gcmType.equalsIgnoreCase("xmpp")) {
                this.gcmCcsService.init(gcmProjectNum, gcmApiKey);
            }
            if (apnsCert != null && apnsPwd != null) {
                if (FileUtil.isValidFile((String)apnsCert)) {
                    try {
                        String decryptApnsPwd = HumusonDecryptor.decrypt((String)apnsPwd, (String)this.encKey);
                        this.openApnsConnection(apnsCert, decryptApnsPwd, SSLChecker.isProduction((InputStream)new FileInputStream(apnsCert), (String)decryptApnsPwd, (String)this.productionCN, (String)this.developmentCN, (boolean)false));
                    }
                    catch (Exception e) {
                        log.error("apns init exception [appInfo:{}, encKey:{}]", new Object[]{appInfo.toString(), this.encKey, e});
                    }
                } else {
                    log.error("APNS Cert File {} is not valid ", (Object)apnsCert);
                }
            } else {
                log.error("APNS Cert is Null or ApnsPwd is Null {}", (Object)appInfo.toString());
            }
        }
        catch (Exception e) {
            log.error("APNS & GCM init error", (Throwable)e);
        }
    }

    @Override
    public void close() {
        try {
            if (this.pushManager != null) {
                this.pushManager.stopConnection();
            }
        }
        catch (Exception e) {
            log.error("error : {}", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void openApnsConnection(String apnsCertPath, String password, boolean isReal) {
        if (this.pushManager == null) {
            try {
                AppleNotificationServerBasicImpl server = new AppleNotificationServerBasicImpl((Object)apnsCertPath, password, isReal);
                this.pushManager = new PushNotificationManager();
                this.pushManager.initializeConnection((AppleNotificationServer)server);
            }
            catch (Exception e) {
                log.error("error : {}", (Throwable)e);
                try {
                    if (this.pushManager != null) {
                        this.pushManager.stopConnection();
                    }
                }
                catch (Exception e2) {
                    log.error("stop connection error", (Throwable)e2);
                }
                finally {
                    this.pushManager = null;
                }
            }
        }
    }

    @Override
    public List<PushResult> request(List<? extends PushQueue> list, boolean isGcmReSend, boolean unActivePublish) throws Exception {
        return this.request(list, isGcmReSend, unActivePublish, false);
    }

    @Override
    public List<PushResult> request(List<? extends PushQueue> list, boolean isGcmReSend, boolean unActivePublish, boolean useWakeupGcm) {
        ArrayList<PushResult> pushResultList;
        block12: {
            String id;
            Collection androidList;
            HashMap<String, PushQueue> reqAndroidUserMap;
            block13: {
                block14: {
                    reqAndroidUserMap = new HashMap<String, PushQueue>();
                    pushResultList = new ArrayList<PushResult>();
                    PushProtos.PushRequest.Builder builder = PushProtos.PushRequest.newBuilder();
                    String androidAppKey = this.appInfo.getAppKey("A");
                    if (this.privateService.useRainboots() && !StringUtils.isNull((String)androidAppKey) && RAINBOOTS_RUN.equals(this.appInfo.getPrivateFlag())) {
                        builder.setAppkey(androidAppKey);
                        builder.setAlias(this.serverName);
                        builder.setType(PushProtos.PushRequest.PushType.ONE2ONE);
                        builder.setQosLevel(PushProtos.PushRequest.QosLevel.valueOf((int)this.privateQosLevel));
                        builder.setUnActivePublish(unActivePublish);
                    }
                    int denyAppVerCount = 0;
                    for (PushQueue pushQueue : list) {
                        PushResult pushResult = this.checkValidation(pushQueue, this.appInfo.getOs(pushQueue.getAppId()));
                        if (pushResult != null) {
                            pushResultList.add(pushResult);
                            continue;
                        }
                        if ("I".equals(this.appInfo.getOs(pushQueue.getAppId()))) {
                            PushResult apnsResult = this.sendApnsMessage(pushQueue);
                            pushResultList.add(apnsResult);
                            continue;
                        }
                        PushProtos.PushRequest.Payload.Builder payloadBuilder = PushProtos.PushRequest.Payload.newBuilder();
                        if (this.privateService.useRainboots() && RAINBOOTS_RUN.equals(this.appInfo.getPrivateFlag())) {
                            payloadBuilder.setId(pushQueue.getPushId() + "_" + pushQueue.getDeviceId() + "_" + pushQueue.getReqUid() + "_" + pushQueue.getCustId());
                            payloadBuilder.setToken(String.valueOf(pushQueue.getDeviceId()));
                            payloadBuilder.setTimeToLive(pushQueue.getPushMessage().getPushTtl() > 0 ? pushQueue.getPushMessage().getPushTtl() : 1800);
                            payloadBuilder.setMsgId(0);
                            String realTimeRainbootsMsg = this.makeRainbootsMessage(pushQueue.getPushMessage());
                            log.debug("realtime rainboots send message : {}", (Object)realTimeRainbootsMsg);
                            payloadBuilder.setMessage(realTimeRainbootsMsg);
                            builder.addPayload(payloadBuilder.build());
                        }
                        reqAndroidUserMap.put(pushQueue.getPushId() + "_" + pushQueue.getDeviceId(), pushQueue);
                    }
                    if (denyAppVerCount > 0) {
                        log.info("deny app version filter count : {}", (Object)denyAppVerCount);
                    }
                    if (reqAndroidUserMap.size() <= 0) break block12;
                    if (this.privateService.useRainboots() && RAINBOOTS_RUN.equals(this.appInfo.getPrivateFlag()) && builder.getPayloadCount() > 0) {
                        long startTime = System.currentTimeMillis();
                        log.debug("rainboots reqeust : {}", (Object)builder.build());
                        List<PushResult> rainbootsResult = this.sendRainboots(reqAndroidUserMap, builder.build(), isGcmReSend, false);
                        pushResultList.addAll(rainbootsResult);
                        log.debug("SEND PUSH RAINBOOTS REQUEST DURATION TIME :{}", (Object)(System.currentTimeMillis() - startTime));
                    }
                    if (reqAndroidUserMap.size() <= 0 || !isGcmReSend) break block13;
                    androidList = reqAndroidUserMap.values();
                    if (!"http".equalsIgnoreCase(this.gcmType)) break block14;
                    pushResultList.addAll(this.gcmHttpServiceImpl.sendGcmOne2OneList(androidList, this.appInfo.getGcmApiKey()));
                    break block12;
                }
                if (!"xmpp".equalsIgnoreCase(this.gcmType)) break block12;
                StringBuilder stringBuilder = new StringBuilder();
                for (PushQueue que : androidList) {
                    stringBuilder.setLength(0);
                    id = stringBuilder.append(que.getPushId()).append("&&").append(que.getDeviceId()).append("&&").append(que.getReqUid()).append("&&").append(que.getCustId()).toString();
                    String ccsMessage = this.gcmCcsService.makeCcsMessage(que, que.getPushMessage(), this.appInfo.getAppGrpId());
                    try {
                        log.info("ccsMessage: {}", (Object)ccsMessage);
                        this.gcmCcsService.sendDownstreamMessage(ccsMessage);
                    }
                    catch (Exception e) {
                        log.error("exception in resendGcm (XMPP) : {}", (Object)que.getPushId(), (Object)e);
                        pushResultList.add(new PushResult(this.appInfo.getAppGrpId(), "2009", stringBuilder.toString(), "A", que.getRowId()));
                        this.gcmCcsService.setHitCount(0);
                        this.gcmCcsService.reset();
                        continue;
                    }
                    pushResultList.add(new PushResult(this.appInfo.getAppGrpId(), "3002", stringBuilder.toString(), "A", que.getRowId()));
                }
                break block12;
            }
            if (reqAndroidUserMap.size() > 0) {
                log.error("reqAndroidUserMap size :{} gcmReSendFlag:{}", (Object)reqAndroidUserMap.size(), (Object)isGcmReSend);
                androidList = reqAndroidUserMap.values();
                StringBuilder stringBuilder = new StringBuilder();
                for (PushQueue pushQueue : androidList) {
                    stringBuilder.setLength(0);
                    id = stringBuilder.append(pushQueue.getPushId()).append("&&").append(pushQueue.getDeviceId()).append("&&").append(pushQueue.getReqUid()).append("&&").append(pushQueue.getCustId()).toString();
                    pushResultList.add(new PushResult(this.appInfo.getAppGrpId(), "8000", id, "A", pushQueue.getRowId()));
                }
            }
        }
        return pushResultList;
    }

    @Override
    public List<PushResult> request(List<? extends PushQueue> list, PushMessage pushMessage, boolean isGcmReSend) {
        return this.request(list, pushMessage, isGcmReSend, false);
    }

    @Override
    public List<PushResult> request(List<? extends PushQueue> list, PushMessage pushMessage, boolean isGcmReSend, boolean unActivePublish) {
        return this.request(list, pushMessage, isGcmReSend, unActivePublish, false);
    }

    @Override
    public List<PushResult> request(List<? extends PushQueue> list, PushMessage pushMessage, boolean isGcmReSend, boolean unActivePublish, boolean useWakeupGcm) {
        HashMap<String, PushQueue> reqAndroidUserMap = new HashMap<String, PushQueue>();
        ArrayList<PushResult> pushResultList = new ArrayList<PushResult>();
        PushProtos.PushRequest.Builder builder = PushProtos.PushRequest.newBuilder();
        String rainbootsBulkMsg = null;
        if (this.privateService.useRainboots() && this.appInfo.getAppKey("A") != null && RAINBOOTS_RUN.equals(this.appInfo.getPrivateFlag())) {
            builder.setAppkey(this.appInfo.getAppKey("A"));
            builder.setAlias(this.serverName);
            builder.setType(PushProtos.PushRequest.PushType.BROADCAST);
            builder.setMsgId((int)(Long.parseLong(pushMessage.getMsgUid()) % 32767L));
            builder.setQosLevel(PushProtos.PushRequest.QosLevel.valueOf((int)this.privateQosLevel));
            builder.setUnActivePublish(unActivePublish);
            if (pushMessage.getPushTtl() > 0) {
                builder.setTimeToLive(pushMessage.getPushTtl());
            } else {
                builder.setTimeToLive(1800);
            }
            rainbootsBulkMsg = this.makeRainbootsMessage(pushMessage);
            builder.setMessage(rainbootsBulkMsg);
        }
        for (PushQueue pushQueue : list) {
            PushResult pushResult = this.checkValidation(pushQueue, this.appInfo.getOs(pushQueue.getAppId()));
            if (pushResult != null) {
                pushResultList.add(pushResult);
                continue;
            }
            if ("I".equals(this.appInfo.getOs(pushQueue.getAppId()))) {
                PushResult apnsResult = this.sendApnsMessage(pushQueue);
                pushResultList.add(apnsResult);
                continue;
            }
            reqAndroidUserMap.put(pushQueue.getPushId() + "_" + pushQueue.getDeviceId(), pushQueue);
            if (!this.privateService.useRainboots() || !RAINBOOTS_RUN.equals(this.appInfo.getPrivateFlag())) continue;
            PushProtos.PushRequest.Payload.Builder payloadBuilder = PushProtos.PushRequest.Payload.newBuilder();
            payloadBuilder.setId(pushQueue.getPushId() + "_" + pushQueue.getDeviceId() + "_" + pushQueue.getReqUid() + "_" + pushQueue.getCustId());
            payloadBuilder.setToken(String.valueOf(pushQueue.getDeviceId()));
            builder.addPayload(payloadBuilder.build());
        }
        if (!reqAndroidUserMap.isEmpty()) {
            Collection androidList;
            if (this.privateService.useRainboots() && RAINBOOTS_RUN.equals(this.appInfo.getPrivateFlag()) && builder.getPayloadCount() > 0) {
                long startTime = System.currentTimeMillis();
                List<PushResult> rainbootsResult = this.sendRainboots(reqAndroidUserMap, builder.build(), isGcmReSend, useWakeupGcm);
                pushResultList.addAll(rainbootsResult);
                log.info("send rainboots [size:{}, elapseTime:{}]", (Object)reqAndroidUserMap.size(), (Object)(System.currentTimeMillis() - startTime));
            }
            if (reqAndroidUserMap.size() > 0 && isGcmReSend) {
                androidList = reqAndroidUserMap.values();
                try {
                    PushQueue[] pushQueueArray = new PushQueue[androidList.size()];
                    androidList.toArray(pushQueueArray);
                    long startTime = System.currentTimeMillis();
                    if ("http".equalsIgnoreCase(this.gcmType)) {
                        Message gcmBulkMessage = this.gcmHttpServiceImpl.makeGcmMessage(pushQueueArray[0]);
                        List<PushResult> gcmSendResult = this.gcmHttpServiceImpl.sendGcmMulticastMessage((PushQueue[])pushQueueArray, gcmBulkMessage, this.appInfo.getGcmApiKey());
                        pushResultList.addAll(gcmSendResult);
                    } else if ("xmpp".equalsIgnoreCase(this.gcmType)) {
                        StringBuilder sb = new StringBuilder();
                        for (PushQueue que : pushQueueArray) {
                            sb.setLength(0);
                            String id = sb.append(que.getPushId()).append("&&").append(que.getDeviceId()).append("&&").append(que.getReqUid()).append("&&").append(que.getCustId()).toString();
                            String ccsMessage = this.gcmCcsService.makeCcsMessage(que, que.getPushMessage(), this.appInfo.getAppGrpId());
                            try {
                                log.info("ccsMessage: {}", (Object)ccsMessage);
                                this.gcmCcsService.sendDownstreamMessage(ccsMessage);
                            }
                            catch (Exception e) {
                                log.error("exception in resendGcm (XMPP) : {}", (Object)que.getPushId(), (Object)e);
                                pushResultList.add(new PushResult(this.appInfo.getAppGrpId(), "2009", sb.toString(), "A", que.getRowId()));
                                this.gcmCcsService.setHitCount(0);
                                this.gcmCcsService.reset();
                                continue;
                            }
                            pushResultList.add(new PushResult(this.appInfo.getAppGrpId(), "3002", sb.toString(), "A", que.getRowId()));
                        }
                    }
                    log.info("send GCM [count:{}, elpasedTime:{}]", (Object)androidList.size(), (Object)(System.currentTimeMillis() - startTime));
                }
                catch (Exception exception) {
                    log.error("GCM Send Error", (Throwable)exception);
                }
            } else if (reqAndroidUserMap.size() > 0) {
                log.error("reqAndroidUserMap size :{} reqAndroidUserMap.values():{}, gcmReSendFlag:{}", new Object[]{reqAndroidUserMap.size(), reqAndroidUserMap.values().size(), isGcmReSend});
                androidList = reqAndroidUserMap.values();
                StringBuilder stringBuilder = new StringBuilder();
                for (PushQueue pushQueue : androidList) {
                    stringBuilder.setLength(0);
                    String id = stringBuilder.append(pushQueue.getPushId()).append("&&").append(pushQueue.getDeviceId()).append("&&").append(pushQueue.getReqUid()).append("&&").append(pushQueue.getCustId()).toString();
                    pushResultList.add(new PushResult(this.appInfo.getAppGrpId(), "8000", id, "A", pushQueue.getRowId()));
                }
            }
        }
        return pushResultList;
    }

    protected List<PushResult> sendRainboots(Map<String, PushQueue> androidMap, PushProtos.PushRequest pushRequest, boolean isGcmReSend, boolean useWakeupGcm) {
        long startTime = System.currentTimeMillis();
        ArrayList<PushResult> pushResultList = new ArrayList<PushResult>();
        PushProtos.PushResponse response = this.privateService.request(pushRequest);
        if (response != null && response.getResult() == PushProtos.PushResponse.ResultType.SUCCESS) {
            log.debug("private server send result : {}", (Object)response.toString());
            int payloadSize = response.getPayloadCount();
            for (int i = payloadSize - 1; i >= 0; --i) {
                String[] ids = response.getPayload(i).getId().split("_");
                PushQueue pq = androidMap.get(ids[0] + "_" + ids[1]);
                if (response.getPayload(i).getResult() == PushProtos.PushResponse.ResultType.SUCCESS) {
                    pushResultList.add(new PushResult(this.appInfo.getAppGrpId(), "3000", response.getPayload(i).getId(), "A", pq.getRowId()));
                    androidMap.remove(ids[0] + "_" + ids[1]);
                } else if (!isGcmReSend) {
                    if (response.getPayload(i).getResult() == PushProtos.PushResponse.ResultType.UNACTIVED_TOKEN) {
                        pushResultList.add(new PushResult(this.appInfo.getAppGrpId(), "3102", response.getPayload(i).getId(), "A", pq.getRowId()));
                    } else if (response.getPayload(i).getResult() == PushProtos.PushResponse.ResultType.INVALID_TOKEN) {
                        pushResultList.add(new PushResult(this.appInfo.getAppGrpId(), "3106", response.getPayload(i).getId(), "A", pq.getRowId()));
                    }
                    androidMap.remove(ids[0] + "_" + ids[1]);
                }
                if (!log.isDebugEnabled()) continue;
                log.debug("return code : {}", (Object)response.getPayload(i).toString());
            }
            long rainbootsElapsedTime = System.currentTimeMillis() - startTime;
            log.info("rainboots send [sendCount:{}, elapsedTime:{}]", (Object)pushRequest.getPayloadCount(), (Object)rainbootsElapsedTime);
            if (useWakeupGcm) {
                this.sendWakeupGcm(pushRequest, androidMap);
            }
        } else {
            log.info("private server send fail result : {}", (Object)(response == null ? "null" : response.getResult().toString()));
            if (!isGcmReSend) {
                Set<String> sendRawIdSet = androidMap.keySet();
                for (String ids : sendRawIdSet) {
                    PushQueue pq = androidMap.get(ids);
                    pushResultList.add(new PushResult(this.appInfo.getAppGrpId(), "8500", ids + "_" + pq.getReqUid() + "_" + pq.getCustId(), "A", pq.getRowId()));
                }
                androidMap.clear();
            }
        }
        return pushResultList;
    }

    protected void sendWakeupGcm(PushProtos.PushRequest pushRequest, Map<String, PushQueue> androidMap) {
        long startTime = System.currentTimeMillis();
        Collection<PushQueue> wakeupGcmList = androidMap.values();
        PushQueue[] wakeupSendRaw = new PushQueue[wakeupGcmList.size()];
        wakeupGcmList.toArray(wakeupSendRaw);
        Message.Builder builder = new Message.Builder();
        builder.timeToLive(180);
        builder.delayWhileIdle(false);
        this.gcmHttpServiceImpl.sendGcmMulticastMessage((PushQueue[])wakeupSendRaw, builder.build(), this.appInfo.getGcmApiKey());
        long gcmWakeUpPushElapsedTime = System.currentTimeMillis() - startTime;
        log.info("gcm wakeup push count : {} elapsedTime : {}", (Object)pushRequest.getPayloadCount(), (Object)gcmWakeUpPushElapsedTime);
    }

    public synchronized PushResult sendApnsMessage(PushQueue pushQueue) {
        StringBuilder sb = new StringBuilder();
        sb.setLength(0);
        String id = sb.append(pushQueue.getPushId()).append("&&").append(pushQueue.getDeviceId()).append("&&").append(pushQueue.getReqUid()).append("&&").append(pushQueue.getCustId()).toString();
        if (this.pushManager == null) {
            return new PushResult(this.appInfo.getAppGrpId(), "1111", id, "I", pushQueue.getRowId());
        }
        try {
            String message = null;
            message = StringUtils.isNull((String)pushQueue.getPushMessage().getPushTitle()) ? pushQueue.getPushMessage().getPushMsg() : pushQueue.getPushMessage().getPushTitle() + "\n" + pushQueue.getPushMessage().getPushMsg();
            String pushKey = pushQueue.getPushMessage().getPushKey();
            String pushValue = pushQueue.getPushMessage().getPushValue();
            PushNotificationPayload payload = PushNotificationPayload.alert((String)message);
            if (this.appInfo.getPushSound() == null) {
                payload.addSound("default");
            } else {
                payload.addSound(this.appInfo.getPushSound());
            }
            if (this.appInfo.getIOsBadgeCount() > 0) {
                payload.addBadge(this.appInfo.getIOsBadgeCount());
            }
            payload.addCustomDictionary("t", pushQueue.getPushMessage().getMsgType());
            payload.addCustomDictionary("i", String.valueOf(pushQueue.getPushMessage().getMsgUid()));
            if (log.isDebugEnabled()) {
                log.debug("apns payload add before size:{} payload:{}", (Object)payload.getPayloadSize(), (Object)payload.toString());
            }
            if (!StringUtils.isNull((String)pushKey) && payload.isEstimatedPayloadSizeAllowedAfterAdding(pushKey, (Object)pushValue)) {
                payload.addCustomDictionary(pushKey, pushValue);
                if (log.isDebugEnabled()) {
                    log.debug("apns payload push key add after size:{} payload:{}", (Object)payload.getPayloadSize(), (Object)payload.toString());
                }
            }
            BasicDevice device = new BasicDevice(pushQueue.getPushToken());
            PushedNotification notification = this.pushManager.sendNotification((Device)device, (Payload)payload, false);
            String errorCode = null;
            if (notification.isSuccessful()) {
                errorCode = "1000";
            } else {
                errorCode = "1111";
                if (notification.getException() != null) {
                    String[] responseParts = notification.getException().toString().split(":");
                    String err = responseParts[0];
                    log.error("APNS error : {}", (Throwable)notification.getException());
                    if (err.contains("DuplicateDeviceException") || err.contains("InvalidDeviceTokenFormatException")) {
                        errorCode = "1001";
                    } else if (err.contains("NullDeviceTokenException")) {
                        errorCode = "1003";
                    } else if (err.contains("NullIdException")) {
                        errorCode = "1004";
                    } else if (err.contains("UnknownDeviceException")) {
                        errorCode = "1005";
                    } else if (err.contains("PayloadMaxSizeExceededException")) {
                        errorCode = "1009";
                    }
                }
            }
            return new PushResult(this.appInfo.getAppGrpId(), errorCode, id, "I", pushQueue.getRowId());
        }
        catch (Exception e) {
            log.error("APNS Send Error", (Throwable)e);
            if (e instanceof InvalidDeviceTokenFormatException) {
                return new PushResult(this.appInfo.getAppGrpId(), "1002", id, "I", pushQueue.getRowId());
            }
            return new PushResult(this.appInfo.getAppGrpId(), "1111", id, "I", pushQueue.getRowId());
        }
    }

    protected String makeRainbootsMessage(PushMessage pushMessage) {
        JSONObject messageJson = new JSONObject();
        try {
            messageJson.put((Object)"notiMsg", (Object)StringUtils.validString((String)pushMessage.getPushMsg()));
            messageJson.put((Object)"notiTitle", (Object)StringUtils.validString((String)pushMessage.getPushTitle()));
            String pushImage = pushMessage.getPushImg();
            if (pushImage != null && !pushImage.startsWith(HTTP_URL) && HTTP_URL.length() >= pushImage.length()) {
                pushImage = "";
            }
            messageJson.put((Object)"notiImg", (Object)(pushImage == null ? "" : pushImage));
            messageJson.put((Object)"message", (Object)pushMessage.getPopupContent());
            messageJson.put((Object)"t", (Object)pushMessage.getMsgType());
            messageJson.put((Object)"i", (Object)String.valueOf(pushMessage.getMsgUid()));
            JSONObject json = new JSONObject();
            if (!StringUtils.isNull((String)pushMessage.getPushKey())) {
                json.put((Object)pushMessage.getPushKey(), (Object)StringUtils.validString((String)pushMessage.getPushValue()));
            }
            if (!StringUtils.isNull((String)this.appInfo.getPushSound())) {
                messageJson.put((Object)"sound", (Object)this.appInfo.getPushSound());
            }
            messageJson.put((Object)"d", (Object)json.toString());
            log.info("rainboots message [{}]", (Object)messageJson.toString());
        }
        catch (Exception e) {
            log.error("exception in makeRainboots messaage", (Throwable)e);
        }
        return messageJson.toString();
    }

    protected PushResult checkValidation(PushQueue pushQueue, String os) {
        StringBuilder sb = new StringBuilder();
        String id = sb.append(pushQueue.getPushId()).append("&&").append(pushQueue.getDeviceId()).append("&&").append(pushQueue.getReqUid()).append("&&").append(pushQueue.getCustId()).toString();
        if ("N".equals(pushQueue.getNotiFlag())) {
            return new PushResult(this.appInfo.getAppGrpId(), "4400", id, os, pushQueue.getRowId());
        }
        if ("I".equals(os)) {
            try {
                new BasicDevice(pushQueue.getPushToken());
            }
            catch (InvalidDeviceTokenFormatException e) {
                return new PushResult(this.appInfo.getAppGrpId(), "1002", id, os, pushQueue.getRowId());
            }
        }
        return null;
    }
}

