/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.batch.service.impl;

import com.humuson.tms.batch.domain.PushSendSchedule;
import com.humuson.tms.batch.service.ScheduleService;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public class PushSendScheduleService
implements ScheduleService<PushSendSchedule> {
    private static final Logger log = LoggerFactory.getLogger(PushSendScheduleService.class);
    ConcurrentHashMap<String, Boolean> runningScheduleMap = new ConcurrentHashMap();
    private String selectSchedule;
    private String updateSchedule;
    @Autowired
    private JdbcTemplate jdbcTemplate;

    @Override
    public boolean isRunning(String key) {
        Boolean isRun = this.runningScheduleMap.get(key);
        if (isRun == null) {
            return false;
        }
        return isRun;
    }

    @Override
    public void setRunning(String id, boolean isRun) {
        this.runningScheduleMap.put(id, isRun);
    }

    @Override
    public List<PushSendSchedule> getScheduleList(Object[] params) {
        List list = this.jdbcTemplate.query(this.selectSchedule, (RowMapper)new RowMapper<PushSendSchedule>(){

            public PushSendSchedule mapRow(ResultSet rs, int rowNum) throws SQLException {
                PushSendSchedule schedule = new PushSendSchedule();
                schedule.setAppGrpKey(rs.getString("APP_GRP_KEY"));
                return schedule;
            }
        }, params);
        return list;
    }

    @Override
    public int updateScheduleStatus(String key, String status) {
        log.info("updateScheduleStatus [key:{}, status:{}]", (Object)key, (Object)status);
        return 0;
    }

    @Override
    public List<PushSendSchedule> getScheduleList() {
        return this.getScheduleList(new Object[0]);
    }

    @Override
    public boolean isCanceled(String key) {
        return false;
    }

    public void setSelectSchedule(String selectSchedule) {
        this.selectSchedule = selectSchedule;
    }

    public void setUpdateSchedule(String updateSchedule) {
        this.updateSchedule = updateSchedule;
    }
}

