/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.batch.service.impl;

import com.humuson.tms.batch.domain.App;
import com.humuson.tms.batch.domain.PushMqResend;
import com.humuson.tms.batch.domain.PushQueue;
import com.humuson.tms.batch.domain.PushResult;
import com.humuson.tms.batch.service.AppUserRemover;
import com.humuson.tms.batch.service.PushResultService;
import com.humuson.tms.common.model.CcsMessageId;
import com.humuson.tms.mq.model.MgsPush;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSourceUtils;
import org.springframework.transaction.annotation.Transactional;

public class PushResultServiceImpl
implements PushResultService {
    private static final Logger log = LoggerFactory.getLogger(PushResultServiceImpl.class);
    @Autowired
    protected NamedParameterJdbcTemplate namedParameterJdbcTemplate;
    @Autowired
    protected JdbcTemplate jdbcTemplate;
    @Autowired
    protected AppUserRemover appUserRemover;
    @Value(value="#{config['not.registed.android.immediately.update']}")
    private boolean immediatelyUpdate;
    private String deletePushQue;
    private String updatePushQue;
    private String insertPushQueLog;
    private String insertSelectPushQueLog;
    private String insertMqResendList;
    private String deleteMqResendList;
    private String updateMqResendList;
    private String insertSelectPushLogDeliver;

    @Override
    public int updateSendingStatus(PushQueue pushQueue) {
        return this.namedParameterJdbcTemplate.update(this.updatePushQue, pushQueue.toMap());
    }

    @Override
    public int[] batchUpdateSendingStatus(List<PushQueue> list) {
        SqlParameterSource[] params = SqlParameterSourceUtils.createBatch((Object[])list.toArray());
        int[] result = null;
        try {
            result = this.namedParameterJdbcTemplate.batchUpdate(this.updatePushQue, params);
        }
        catch (Exception e) {
            log.error("batch update failed", (Throwable)e);
            result = null;
        }
        return result;
    }

    @Override
    public int updatePushQueue(PushQueue pushQueue) {
        int result = this.namedParameterJdbcTemplate.update(this.deletePushQue, pushQueue.toMap());
        if (result > 0) {
            result *= this.namedParameterJdbcTemplate.update(this.insertPushQueLog, pushQueue.toMap());
        }
        return result;
    }

    @Override
    public int[] batchUpdatePushQueue(List<PushQueue> list) {
        SqlParameterSource[] params = SqlParameterSourceUtils.createBatch((Object[])list.toArray());
        int[] result = null;
        try {
            result = this.namedParameterJdbcTemplate.batchUpdate(this.insertPushQueLog, params);
            this.namedParameterJdbcTemplate.batchUpdate(this.deletePushQue, params);
        }
        catch (Exception e) {
            log.error("batch update failed", (Throwable)e);
            result = null;
        }
        return result;
    }

    @Override
    public int updatePushResult(PushResult result) {
        int rtnCnt = 1;
        if ("3001".equals(result.getErrorCode())) {
            return rtnCnt;
        }
        if ("3000".equals(result.getErrorCode())) {
            rtnCnt = this.namedParameterJdbcTemplate.update(this.updatePushQue, result.toMap());
        } else {
            rtnCnt = this.namedParameterJdbcTemplate.update(this.insertPushQueLog, result.toMap());
            rtnCnt *= this.namedParameterJdbcTemplate.update(this.deletePushQue, result.toMap());
            if ("2006".equals(result.getErrorCode())) {
                rtnCnt = this.immediatelyUpdate ? (rtnCnt *= this.appUserRemover.updateAndroidNotRegisterToken(result.getDeviceId())) : (rtnCnt *= this.appUserRemover.insertAppRemoveDeviceList(result.getDeviceId()));
            }
        }
        return rtnCnt;
    }

    @Override
    public void batchUpdatePushResult(List<PushResult> resList) {
        SqlParameterSource[] params;
        ArrayList<PushResult> sendingList = new ArrayList<PushResult>();
        ArrayList<PushResult> completedList = new ArrayList<PushResult>();
        ArrayList<Integer> removeList = new ArrayList<Integer>();
        for (PushResult result : resList) {
            if ("3001".equals(result.getErrorCode())) continue;
            if ("3000".equals(result.getErrorCode()) || "3002".equals(result.getErrorCode())) {
                sendingList.add(result);
                continue;
            }
            completedList.add(result);
            if (!"2006".equals(result.getErrorCode())) continue;
            removeList.add(result.getDeviceId());
        }
        if (!sendingList.isEmpty()) {
            params = SqlParameterSourceUtils.createBatch((Object[])sendingList.toArray());
            this.namedParameterJdbcTemplate.batchUpdate(this.updatePushQue, params);
        }
        if (!completedList.isEmpty()) {
            log.info("completedList size:{}", (Object)completedList.size());
            params = SqlParameterSourceUtils.createBatch((Object[])completedList.toArray());
            this.namedParameterJdbcTemplate.batchUpdate(this.insertPushQueLog, params);
            this.namedParameterJdbcTemplate.batchUpdate(this.deletePushQue, params);
        }
        if (!removeList.isEmpty()) {
            this.updateAndroidDeleteAppUser(removeList);
        }
    }

    private void updateAndroidDeleteAppUser(List<Integer> removeList) {
        log.info("not.registed.android.immediately.update : {}", (Object)this.immediatelyUpdate);
        if (this.immediatelyUpdate) {
            log.info("GCM ERROR CODE 2006 Not Regist User Device DelYnFlag N=>Y Update [ uptCnt : {} ]", (Object)removeList.size());
            try {
                this.appUserRemover.updateAndroidNotRegisterToken(removeList);
            }
            catch (Exception e) {
                log.error("update Android NotRegisterToken error", (Throwable)e);
                for (Integer deviceId : removeList) {
                    try {
                        this.appUserRemover.updateAndroidNotRegisterToken(deviceId);
                    }
                    catch (Exception e2) {
                        log.error("update Android NotRegisterToken error [deviceId:{}]", (Object)deviceId, (Object)e2);
                    }
                }
            }
        } else {
            log.info("GCM ERROR CODE 2006 Not Regist User Device => Insert TMS_APP_DELETE_DEVICE_LIST  [ insertCnt : {} ]", (Object)removeList.size());
            try {
                this.appUserRemover.insertAppRemoveDeviceList(removeList);
            }
            catch (Exception e) {
                log.error("insert Android NotRegisterToken error", (Throwable)e);
                for (Integer deviceId : removeList) {
                    try {
                        this.appUserRemover.insertAppRemoveDeviceList(deviceId);
                    }
                    catch (Exception e2) {
                        log.error("insert Android NotRegisterToken error [deviceId:{}]", (Object)deviceId, (Object)e2);
                    }
                }
            }
        }
    }

    @Override
    @Transactional
    public int deleteInsertPushResult(CcsMessageId msg, String errorCode) {
        int cnt = 0;
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("pushId", msg.getPushId());
        paramMap.put("rtnType", "S");
        paramMap.put("errorCode", errorCode);
        paramMap.put("appOs", "A");
        paramMap.put("chunkId", msg.getChunkId());
        paramMap.put("appGrpId", msg.getAppGrpId());
        this.namedParameterJdbcTemplate.update(this.insertSelectPushQueLog, paramMap);
        this.namedParameterJdbcTemplate.update(this.deletePushQue, paramMap);
        return cnt;
    }

    @Override
    public int batchInsertSendingStatus(List<MgsPush.PushPayload> privateSendList, App appInfo, String serverId) {
        ArrayList<PushMqResend> pushMqResendList = new ArrayList<PushMqResend>();
        for (MgsPush.PushPayload payload : privateSendList) {
            PushMqResend pushMqResend = new PushMqResend();
            pushMqResend.setAppGrpKey(appInfo.getAppGrpKey());
            pushMqResend.setDeviceId(Long.parseLong(payload.getId().split("&&")[1]));
            pushMqResend.setReqUid(payload.getId().split("&&")[2]);
            pushMqResend.setCustId(payload.getId().split("&&")[3]);
            pushMqResend.setPushToken(payload.getToken());
            pushMqResend.setMsgUid(payload.getGcmMessage().getMsgId());
            pushMqResend.setPushTitle(payload.getGcmMessage().getPushNotiTitle());
            pushMqResend.setPushMsg(payload.getGcmMessage().getPushNotiMsg());
            pushMqResend.setMsgType(payload.getGcmMessage().getMsgType());
            pushMqResend.setPopupContent(payload.getGcmMessage().getPushRichContent());
            pushMqResend.setPushTtl(payload.getGcmMessage().getTimeToLive());
            pushMqResend.setPushImg(payload.getGcmMessage().getPushNotiImg());
            JSONObject json = null;
            JSONParser parser = new JSONParser();
            try {
                json = (JSONObject)parser.parse(payload.getGcmMessage().getPushData());
                pushMqResend.setPushKey("l");
                pushMqResend.setPushValue((String)json.get((Object)"l"));
            }
            catch (ParseException e) {
                log.error("pushKey/pushValue json parse error : {}", (Throwable)e);
                pushMqResend.setPushKey("l");
                pushMqResend.setPushValue("");
            }
            pushMqResend.setServerId(serverId);
            pushMqResendList.add(pushMqResend);
        }
        SqlParameterSource[] params = SqlParameterSourceUtils.createBatch((Object[])pushMqResendList.toArray());
        this.namedParameterJdbcTemplate.batchUpdate(this.insertMqResendList, params);
        return 0;
    }

    @Override
    public int[] deleteMqResendList(List<Object[]> prvPushMqDeleteList) {
        return this.jdbcTemplate.batchUpdate(this.deleteMqResendList, prvPushMqDeleteList);
    }

    @Override
    public int deleteMqResend(String prvPushMqDeleteTargetReqUid) {
        return this.jdbcTemplate.update(this.deleteMqResendList, new Object[]{prvPushMqDeleteTargetReqUid});
    }

    @Override
    public int[] updateMqResendList(List<Object[]> prvPushMqUpdateList) {
        return this.jdbcTemplate.batchUpdate(this.updateMqResendList, prvPushMqUpdateList);
    }

    @Override
    @Transactional
    public int insertPushDeliver(CcsMessageId msg, String errorCode, String resDate) {
        int cnt = 0;
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("pushId", msg.getPushId());
        paramMap.put("rtnType", "D");
        paramMap.put("errorCode", errorCode);
        paramMap.put("appOs", "A");
        paramMap.put("chunkId", msg.getChunkId());
        paramMap.put("appGrpId", msg.getAppGrpId());
        paramMap.put("reqUid", msg.getReqUid());
        paramMap.put("custId", msg.getCustId());
        paramMap.put("deviceId", msg.getDeviceId());
        paramMap.put("resDate", resDate);
        cnt = this.namedParameterJdbcTemplate.update(this.insertSelectPushLogDeliver, paramMap);
        log.debug("insertSelectPushLogDeliver {}", (Object)cnt);
        return cnt;
    }

    public void setDeletePushQue(String deletePushQue) {
        this.deletePushQue = deletePushQue;
    }

    public void setUpdatePushQue(String updatePushQue) {
        this.updatePushQue = updatePushQue;
    }

    public void setInsertPushQueLog(String insertPushQueLog) {
        this.insertPushQueLog = insertPushQueLog;
    }

    public void setInsertSelectPushQueLog(String insertSelectPushQueLog) {
        this.insertSelectPushQueLog = insertSelectPushQueLog;
    }

    public void setInsertMqResendList(String insertMqResendList) {
        this.insertMqResendList = insertMqResendList;
    }

    public void setDeleteMqResendList(String deleteMqResendList) {
        this.deleteMqResendList = deleteMqResendList;
    }

    public void setUpdateMqResendList(String updateMqResendList) {
        this.updateMqResendList = updateMqResendList;
    }

    public void setInsertSelectPushLogDeliver(String insertSelectPushLogDeliver) {
        this.insertSelectPushLogDeliver = insertSelectPushLogDeliver;
    }
}

