/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.batch.service.impl;

import com.humuson.tms.batch.domain.App;
import com.humuson.tms.batch.domain.PushMessage;
import com.humuson.tms.batch.domain.PushReSendSchedule;
import com.humuson.tms.batch.service.PushInfoService;
import com.humuson.tms.batch.service.ScheduleService;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public class PushReSendScheduleService
implements ScheduleService<PushReSendSchedule> {
    private static final Logger log = LoggerFactory.getLogger(PushReSendScheduleService.class);
    ConcurrentHashMap<String, Boolean> runningScheduleMap = new ConcurrentHashMap();
    private String selectSchedule;
    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Autowired
    protected PushInfoService<App, PushMessage> pushInfoService;

    @Override
    public boolean isRunning(String key) {
        Boolean isRun = this.runningScheduleMap.get(key);
        if (isRun == null) {
            return false;
        }
        return isRun;
    }

    @Override
    public void setRunning(String id, boolean isRun) {
        this.runningScheduleMap.put(id, isRun);
    }

    @Override
    public List<PushReSendSchedule> getScheduleList(Object[] params) {
        List list = this.jdbcTemplate.query(this.selectSchedule, (RowMapper)new RowMapper<PushReSendSchedule>(){

            public PushReSendSchedule mapRow(ResultSet rs, int rowNum) throws SQLException {
                PushReSendSchedule schedule = new PushReSendSchedule();
                schedule.setAppGrpKey(rs.getString("APP_GRP_KEY"));
                int appGrpId = PushReSendScheduleService.this.pushInfoService.getAppGrpIdByAppGrpKey(schedule.getAppGrpKey());
                schedule.setAppGrpId(appGrpId);
                schedule.setServerId(rs.getString("SERVER_ID"));
                schedule.setSendType(rs.getString("SEND_TYPE"));
                return schedule;
            }
        }, params);
        if (log.isDebugEnabled()) {
            log.debug("PushReSend Schedule Count:{}", (Object)list.size());
        }
        return list;
    }

    @Override
    public int updateScheduleStatus(String key, String status) {
        return 0;
    }

    @Override
    public List<PushReSendSchedule> getScheduleList() {
        return this.getScheduleList(new Object[0]);
    }

    @Override
    public boolean isCanceled(String key) {
        return false;
    }

    public void setSelectSchedule(String selectSchedule) {
        this.selectSchedule = selectSchedule;
    }
}

