/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.batch.service.impl;

import com.humuson.tms.batch.domain.App;
import com.humuson.tms.batch.domain.PushMessage;
import com.humuson.tms.batch.service.PushInfoService;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.jdbc.core.JdbcTemplate;

public class PushInfoServiceImpl
implements PushInfoService<App, PushMessage> {
    private static final Logger log = LoggerFactory.getLogger(PushInfoServiceImpl.class);
    @Autowired
    protected JdbcTemplate jdbcTemplate;
    protected String selectPushCertInfo;
    protected String selectPushCertInfoByAppKey;
    protected String selectAppGrpIdByAppGrpKey;
    protected String selectAppGrpIdByAppKey;
    protected String selectAndroidAppKeyByAppGrpId;
    @Value(value="#{config['ios.cert.path']}")
    protected String iosCertPath;

    @Override
    @Cacheable(value={"appGrpKeyCache"}, key="#appGrpKey")
    public App getAppInfo(String appGrpKey) {
        App pushAppInfo = new App();
        List pushCertList = this.jdbcTemplate.queryForList(this.selectPushCertInfo, new Object[]{appGrpKey});
        String osType = null;
        for (Map map : pushCertList) {
            if (log.isDebugEnabled()) {
                log.debug("pushCert :{}", (Object)map.toString());
            }
            int appId = Integer.parseInt(map.get("APP_ID").toString());
            int appGrpId = Integer.parseInt(map.get("APP_GRP_ID").toString());
            osType = map.get("OS").toString();
            if ("I".equals(osType)) {
                String pushCert = this.iosCertPath.concat(File.separator).concat(map.get("PUSH_CERT").toString());
                pushAppInfo.setApnsPushCert(pushCert);
                pushAppInfo.setApnsPushPwd(map.get("ENC_2_PA").toString());
                pushAppInfo.putOs(appId, "I");
                pushAppInfo.putAppKey("I", map.get("APP_KEY").toString());
            } else {
                pushAppInfo.setGcmApiKey(map.get("GCM_API_KEY1").toString());
                pushAppInfo.putOs(appId, "A");
                pushAppInfo.putAppKey("A", map.get("APP_KEY").toString());
                pushAppInfo.setDenyAppVersion(map.get("DENY_APP_VER") == null ? "" : map.get("DENY_APP_VER").toString());
                pushAppInfo.setGcmProjectNum(Long.parseLong(map.get("GCM_PROJECT_NUM").toString()));
            }
            String privateFlag = "N";
            if (map.get("PRV_FLAG") != null) {
                privateFlag = map.get("PRV_FLAG").toString();
            }
            pushAppInfo.setPrivateFlag(privateFlag);
            if (map.get("PUSH_SOUND") != null) {
                pushAppInfo.setPushSound(map.get("PUSH_SOUND").toString());
            }
            pushAppInfo.setAppGrpId(appGrpId);
        }
        return pushAppInfo;
    }

    @Override
    @Cacheable(value={"appGrpIdByAppGrpKeyCache"}, key="#appGrpKey")
    public Integer getAppGrpIdByAppGrpKey(String appGrpKey) {
        return (Integer)this.jdbcTemplate.queryForObject(this.selectAppGrpIdByAppGrpKey, new Object[]{appGrpKey}, Integer.class);
    }

    @Override
    @Cacheable(value={"appGrpIdByAppKeyCache"}, key="#appKey")
    public Integer getAppGrpIdByAppKey(String appKey) {
        return (Integer)this.jdbcTemplate.queryForObject(this.selectAppGrpIdByAppKey, new Object[]{appKey}, Integer.class);
    }

    @Override
    @Cacheable(value={"androidAppKeyByAppGrpId"}, key="#appGrpId")
    public String selectAndroidAppKeyByAppGrpId(int appGrpId) {
        String appKey = (String)this.jdbcTemplate.queryForObject(this.selectAndroidAppKeyByAppGrpId, new Object[]{appGrpId}, String.class);
        return appKey;
    }

    @Override
    @Cacheable(value={"appInfoByAppKeyCache"}, key="#appKey")
    public App getAppInfoByAppKey(String appKey) {
        App pushAppInfo = new App();
        List pushCertList = this.jdbcTemplate.queryForList(this.selectPushCertInfoByAppKey, new Object[]{appKey});
        String osType = null;
        for (Map map : pushCertList) {
            if (log.isDebugEnabled()) {
                log.debug("pushCert :{}", (Object)map.toString());
            }
            int appId = Integer.parseInt(map.get("APP_ID").toString());
            int appGrpId = Integer.parseInt(map.get("APP_GRP_ID").toString());
            osType = map.get("OS").toString();
            if ("I".equals(osType)) {
                String pushCert = this.iosCertPath.concat(File.separator).concat(map.get("PUSH_CERT").toString());
                pushAppInfo.setApnsPushCert(pushCert);
                pushAppInfo.setApnsPushPwd(map.get("ENC_2_PA").toString());
                pushAppInfo.putOs(appId, "I");
                pushAppInfo.putAppKey("I", map.get("APP_KEY").toString());
            } else {
                pushAppInfo.setGcmApiKey(map.get("GCM_API_KEY1").toString());
                pushAppInfo.putOs(appId, "A");
                pushAppInfo.putAppKey("A", map.get("APP_KEY").toString());
                pushAppInfo.setDenyAppVersion(map.get("DENY_APP_VER") == null ? "" : map.get("DENY_APP_VER").toString());
                pushAppInfo.setGcmProjectNum(Long.parseLong(map.get("GCM_PROJECT_NUM").toString()));
            }
            String privateFlag = "N";
            if (map.get("PRV_FLAG") != null) {
                privateFlag = map.get("PRV_FLAG").toString();
            }
            pushAppInfo.setPrivateFlag(privateFlag);
            if (map.get("PUSH_SOUND") != null) {
                pushAppInfo.setPushSound(map.get("PUSH_SOUND").toString());
            }
            pushAppInfo.setAppGrpId(appGrpId);
            pushAppInfo.setAppGrpKey(map.get("APP_GRP_KEY").toString());
        }
        return pushAppInfo;
    }

    public void setSelectPushCertInfo(String selectPushCertInfo) {
        this.selectPushCertInfo = selectPushCertInfo;
    }

    public void setSelectPushCertInfoByAppKey(String selectPushCertInfoByAppKey) {
        this.selectPushCertInfoByAppKey = selectPushCertInfoByAppKey;
    }

    public void setSelectAppGrpIdByAppGrpKey(String selectAppGrpIdByAppGrpKey) {
        this.selectAppGrpIdByAppGrpKey = selectAppGrpIdByAppGrpKey;
    }

    public void setSelectAppGrpIdByAppKey(String selectAppGrpIdByAppKey) {
        this.selectAppGrpIdByAppKey = selectAppGrpIdByAppKey;
    }

    public void setSelectAndroidAppKeyByAppGrpId(String selectAndroidAppKeyByAppGrpId) {
        this.selectAndroidAppKeyByAppGrpId = selectAndroidAppKeyByAppGrpId;
    }
}

