/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.batch.service.impl;

import com.humuson.tms.batch.domain.PushFeedbackSchedule;
import com.humuson.tms.batch.service.ScheduleService;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public class PushFeedbackScheduleService
implements ScheduleService<PushFeedbackSchedule> {
    ConcurrentHashMap<String, Boolean> runningScheduleMap = new ConcurrentHashMap();
    private String selectSchedule;
    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Value(value="#{config['use.tms.private.server']}")
    private boolean usePrivate;
    @Autowired
    private RedisTemplate<String, String> redisTemplate;

    @Override
    public List<PushFeedbackSchedule> getScheduleList() {
        return this.getScheduleList(new Object[0]);
    }

    @Override
    public boolean isRunning(String key) {
        Boolean isRun = this.runningScheduleMap.get(key);
        if (isRun == null) {
            return false;
        }
        return isRun;
    }

    @Override
    public void setRunning(String key, boolean isRun) {
        this.runningScheduleMap.put(key, isRun);
    }

    @Override
    public List<PushFeedbackSchedule> getScheduleList(Object[] params) {
        return this.jdbcTemplate.query(this.selectSchedule, params, (RowMapper)new RowMapper<PushFeedbackSchedule>(){

            public PushFeedbackSchedule mapRow(ResultSet rs, int rowNum) throws SQLException {
                PushFeedbackSchedule schedule = new PushFeedbackSchedule();
                int count = rs.getInt("COUNT");
                String appKey = rs.getString("APP_KEY");
                schedule.setAppGrpId(rs.getInt("APP_GRP_ID"));
                schedule.setAppKey(appKey);
                if (count == 0 && PushFeedbackScheduleService.this.usePrivate) {
                    StringBuilder sb = new StringBuilder();
                    sb.setLength(0);
                    sb.append("feedbacks").append(":").append(appKey);
                    if (PushFeedbackScheduleService.this.redisTemplate.opsForList().size((Object)sb.toString()) > 0L) {
                        count = 1;
                    }
                }
                schedule.setCnt(count);
                return schedule;
            }
        });
    }

    @Override
    public int updateScheduleStatus(String key, String status) {
        return 0;
    }

    @Override
    public boolean isCanceled(String key) {
        return false;
    }

    public void setSelectSchedule(String selectSchedule) {
        this.selectSchedule = selectSchedule;
    }
}

