/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.batch.service.impl;

import com.humuson.rainboots.client.PushSendClientService;
import com.humuson.rainboots.client.PushSendClientServiceImpl;
import com.humuson.rainboots.proto.messages.PushProtos;
import com.humuson.tms.batch.service.PrivatePushService;
import com.humuson.tms.common.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

public class PrivatePushServiceImpl
implements PrivatePushService<PushProtos.PushResponse, PushProtos.PushRequest> {
    private static Logger logger = LoggerFactory.getLogger(PrivatePushServiceImpl.class);
    @Value(value="#{config['tms.private.server.list']}")
    private String serverList;
    @Value(value="#{config['use.tms.private.server']}")
    private boolean usePrivate;
    @Value(value="#{config['tms.private.timeout.mils']}")
    private long sendTimeoutMils;
    private PushSendClientService rainbootsClientService;

    @Override
    public void init() {
        if (!StringUtils.isNull((String)this.serverList) && this.usePrivate) {
            this.rainbootsClientService = new PushSendClientServiceImpl(this.serverList, this.sendTimeoutMils);
            this.rainbootsClientService.init();
        }
    }

    @Override
    public void connect() {
    }

    @Override
    public void disconnect() {
        if (this.usePrivate) {
            this.rainbootsClientService.disconnect();
        }
    }

    @Override
    public boolean isActive() {
        if (!this.usePrivate || this.rainbootsClientService == null) {
            return false;
        }
        return this.rainbootsClientService.isActive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PushProtos.PushResponse request(PushProtos.PushRequest requestProtoBuf) {
        if (!this.isActive()) {
            logger.error("rainboots send service is null.... try reconnect...");
            this.rainbootsClientService.connect();
            if (!this.isActive()) {
                logger.error("rainbootsClientService is all down!!!");
                return null;
            }
        }
        PushProtos.PushResponse pushResponse = null;
        try {
            PushSendClientService pushSendClientService = this.rainbootsClientService;
            synchronized (pushSendClientService) {
                pushResponse = this.rainbootsClientService.request(requestProtoBuf);
            }
        }
        catch (Exception e) {
            logger.error("exception : {}", (Throwable)e);
        }
        return pushResponse;
    }

    @Override
    public boolean useRainboots() {
        return this.usePrivate;
    }

    @Override
    public void setRunning(boolean isRunning) {
    }

    @Override
    public boolean isRunning() {
        return false;
    }
}

