/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.batch.service.impl;

import com.humuson.tms.batch.service.PostIdDevideService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;

public class PostIdDevideServiceImpl
implements PostIdDevideService {
    private static final Logger log = LoggerFactory.getLogger(PostIdDevideServiceImpl.class);
    @Autowired
    JdbcTemplate jdbcTemplate;
    private String selectAbTestInfo;
    private String selectAbTestPostIds;

    @Override
    public List<Properties> getAbTestPostIds(String msgId, String postId) {
        Map<String, Object> abTestMap = this.getAbTestInfo(msgId);
        int abTestCount = Integer.parseInt(abTestMap.get("AB_TEST_COUNT").toString());
        double abTestRate = Double.parseDouble(abTestMap.get("AB_TEST_RATE").toString());
        ArrayList<Properties> abTestPostIdList = new ArrayList<Properties>();
        List postIds = this.jdbcTemplate.queryForList(this.selectAbTestPostIds, String.class, new Object[]{msgId, postId});
        for (String abPostId : postIds) {
            if (abPostId.equals(postId)) continue;
            Properties properties = new Properties();
            properties.put("POST_ID", abPostId);
            properties.put("AB_TEST_RATE", String.valueOf(abTestRate / (double)abTestCount));
            abTestPostIdList.add(properties);
        }
        Properties properties = new Properties();
        properties.put("POST_ID", postId);
        properties.put("AB_TEST_RATE", String.valueOf(100.0 - abTestRate));
        abTestPostIdList.add(properties);
        return abTestPostIdList;
    }

    @Override
    public Map<String, Object> getAbTestInfo(String msgId) {
        Map abTestMap = this.jdbcTemplate.queryForMap(this.selectAbTestInfo, new Object[]{msgId});
        log.info("AB Test info [msgId:{}, map:{}]", (Object)msgId, (Object)abTestMap.toString());
        return abTestMap;
    }

    public void setSelectAbTestInfo(String selectAbTestInfo) {
        this.selectAbTestInfo = selectAbTestInfo;
    }

    public void setSelectAbTestPostIds(String selectAbTestPostIds) {
        this.selectAbTestPostIds = selectAbTestPostIds;
    }
}

