/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.batch.service.impl;

import com.humuson.tms.batch.domain.OptmzSchedule;
import com.humuson.tms.batch.service.ScheduleService;
import com.humuson.tms.constrants.ChannelType;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public class OptmzManualChnScheduleService
implements ScheduleService<OptmzSchedule> {
    private static final Logger log = LoggerFactory.getLogger(OptmzManualChnScheduleService.class);
    ConcurrentHashMap<String, Boolean> runningScheduleMap = new ConcurrentHashMap();
    private String selectSchedule;
    private String updateSchedule;
    @Autowired
    private JdbcTemplate jdbcTemplate;

    @Override
    public boolean isRunning(String key) {
        Boolean isRun = this.runningScheduleMap.get(key);
        if (isRun == null) {
            return false;
        }
        return isRun;
    }

    @Override
    public void setRunning(String id, boolean isRun) {
        this.runningScheduleMap.put(id, isRun);
    }

    @Override
    public List<OptmzSchedule> getScheduleList(Object[] params) {
        List list = this.jdbcTemplate.query(this.selectSchedule, (RowMapper)new RowMapper<OptmzSchedule>(){

            public OptmzSchedule mapRow(ResultSet rs, int rowNum) throws SQLException {
                OptmzSchedule schedule = new OptmzSchedule();
                schedule.setPPostId(rs.getString("P_POST_ID"));
                schedule.setPostId(rs.getString("POST_ID"));
                schedule.setOptmzTargetType(rs.getString("TARGET_TYPE"));
                schedule.setMsgId(rs.getString("MSG_ID"));
                schedule.setChannelType(ChannelType.valueOfCode((String)rs.getString("CHN_TYPE")));
                return schedule;
            }
        });
        log.info("Optmz select schedule count : {}", (Object)list.size());
        return list;
    }

    @Override
    public int updateScheduleStatus(String key, String status) {
        int cnt = this.jdbcTemplate.update(this.updateSchedule, new Object[]{status, key});
        log.info("update schedule status [key:{}, status:{}, uptCnt:{}]", new Object[]{key, status, cnt});
        return cnt;
    }

    @Override
    public List<OptmzSchedule> getScheduleList() {
        return this.getScheduleList(new Object[0]);
    }

    @Override
    public boolean isCanceled(String key) {
        return false;
    }

    public void setSelectSchedule(String selectSchedule) {
        this.selectSchedule = selectSchedule;
    }

    public void setUpdateSchedule(String updateSchedule) {
        this.updateSchedule = updateSchedule;
    }
}

