/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.batch.service.impl;

import com.apple.ios.apns.ApnsConnectionManager;
import com.google.android.gcm.server.Message;
import com.humuson.rainboots.proto.messages.PushProtos;
import com.humuson.tms.batch.domain.App;
import com.humuson.tms.batch.domain.PushMessage;
import com.humuson.tms.batch.service.GcmHttpService;
import com.humuson.tms.batch.service.PrivatePushService;
import com.humuson.tms.batch.service.PushResultService;
import com.humuson.tms.batch.service.PushSendService;
import com.humuson.tms.batch.service.impl.GcmCcsService;
import com.humuson.tms.common.security.HumusonDecryptor;
import com.humuson.tms.common.util.FileUtil;
import com.humuson.tms.common.util.StringUtils;
import com.humuson.tms.mq.model.MgsPush;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javapns.devices.Device;
import javapns.devices.exceptions.InvalidDeviceTokenFormatException;
import javapns.devices.implementations.basic.BasicDevice;
import javapns.notification.AppleNotificationServer;
import javapns.notification.AppleNotificationServerBasicImpl;
import javapns.notification.Payload;
import javapns.notification.PushNotificationManager;
import javapns.notification.PushNotificationPayload;
import javapns.notification.PushedNotification;
import org.jivesoftware.smack.SmackException;
import org.json.simple.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;

public class MqPushSendServiceImpl
implements PushSendService<MgsPush.Request, MgsPush.Response> {
    private static final Logger log = LoggerFactory.getLogger(MqPushSendServiceImpl.class);
    protected static final String DEFAULT_SERVER_NAME = "TMS-SEND-01";
    protected static final String RAINBOOTS_RUN = "Y";
    @Autowired
    protected PrivatePushService<PushProtos.PushResponse, PushProtos.PushRequest> privateService;
    @Value(value="#{config['use.mgs.public.push']}")
    protected boolean useMgsPublicPush;
    @Value(value="#{config['tms.db.enc.key']}")
    protected String encKey;
    protected PushNotificationManager pushManager;
    @Autowired
    @Qualifier(value="gcmHttpMqServiceImpl")
    protected GcmHttpService<MgsPush.Response.ResponsePayload, MgsPush.PushPayload> gcmHttpMqServiceImpl;
    @Autowired
    PushResultService pushResultServiceImpl;
    @Autowired
    protected GcmCcsService gcmCcsService;
    @Autowired
    ApnsConnectionManager apnsConnectionManager;
    @Value(value="#{config['send.gcm.type']}")
    protected String gcmType;
    protected App appInfo;
    protected Map<String, Boolean> denyAppVersionMap = new ConcurrentHashMap<String, Boolean>();
    @Value(value="#{config['tms.private.qos.level']}")
    protected int privateQosLevel;
    private String serverName;
    static final int DEFAULT_PUSH_LIVE_TIME = 1800;

    public MqPushSendServiceImpl() {
        this.serverName = DEFAULT_SERVER_NAME;
        log.debug("PushSendServiceImpl :{} instance generate hashCode:{}", (Object)this.serverName, (Object)this.hashCode());
    }

    public MqPushSendServiceImpl(String serverName) {
        this.serverName = serverName;
        log.debug("PushSendServiceImpl :{} instance generate hashCode:{}", (Object)serverName, (Object)this.hashCode());
    }

    @Override
    public void init(App appInfo) {
        try {
            String[] denyAppVersions;
            this.appInfo = appInfo;
            for (String denyAppVer : denyAppVersions = appInfo.getDenyAppVersion().split(",")) {
                this.denyAppVersionMap.put(denyAppVer, true);
            }
            String apnsCert = appInfo.getApnsPushCert();
            String apnsPwd = appInfo.getApnsPushPwd();
            String gcmApiKey = appInfo.getGcmApiKey();
            long gcmProjectNum = appInfo.getGcmProjectNum();
            if (MgsPush.PushChnType.GCM.equals((Object)appInfo.getReqPushChnType())) {
                if (gcmApiKey != null && this.gcmType.equalsIgnoreCase("http")) {
                    this.gcmHttpMqServiceImpl.init(appInfo);
                } else if (gcmApiKey != null && this.gcmType.equalsIgnoreCase("xmpp")) {
                    this.gcmCcsService.init(gcmProjectNum, gcmApiKey);
                }
            } else if (MgsPush.PushChnType.APNS.equals((Object)appInfo.getReqPushChnType())) {
                if (apnsCert != null && apnsPwd != null) {
                    if (FileUtil.isValidFile((String)apnsCert)) {
                        try {
                            String decryptApnsPwd = HumusonDecryptor.decrypt((String)apnsPwd, (String)this.encKey);
                            this.pushManager = this.apnsConnectionManager.getPushNotificationManager(appInfo.getAppKey("I"), apnsCert, decryptApnsPwd);
                        }
                        catch (Exception e) {
                            log.error("apns init exception [appInfo:{}, encKey:{}] error : {}", new Object[]{appInfo.toString(), this.encKey, e});
                        }
                    } else {
                        log.error("APNS Cert File {} is not valid ", (Object)apnsCert);
                    }
                } else {
                    log.error("APNS Cert is Null or ApnsPwd is Null {}", (Object)appInfo.toString());
                }
            }
        }
        catch (Exception e) {
            log.error("APNS & GCM init error", (Throwable)e);
        }
    }

    @Override
    public void close() {
    }

    @Override
    public MgsPush.Response request(MgsPush.Request request, boolean isGcmReSend, boolean unActivePublish) throws Exception {
        return this.request(request, isGcmReSend, unActivePublish, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MgsPush.Response request(MgsPush.Request request, boolean isGcmReSend, boolean unActivePublish, boolean useWakeupGcm) {
        HashMap<String, MgsPush.PushPayload> reqAndroidUserMap = new HashMap<String, MgsPush.PushPayload>();
        ArrayList<MgsPush.PushPayload> privateSendingList = new ArrayList<MgsPush.PushPayload>();
        MgsPush.Response.Builder mqResponseBuilder = MgsPush.Response.newBuilder();
        MgsPush.Response.ResponsePayload.Builder responsePayloadBuilder = MgsPush.Response.ResponsePayload.newBuilder();
        boolean isGCM = MgsPush.PushChnType.GCM.equals((Object)request.getPushChnType());
        boolean isAPNS = MgsPush.PushChnType.APNS.equals((Object)request.getPushChnType());
        String serverId = request.getSeverId();
        PushProtos.PushRequest.Builder builder = PushProtos.PushRequest.newBuilder();
        String androidAppKey = this.appInfo.getAppKey("A");
        if (this.privateService.useRainboots() && !StringUtils.isNull((String)androidAppKey) && RAINBOOTS_RUN.equals(this.appInfo.getPrivateFlag())) {
            builder.setAppkey(androidAppKey);
            builder.setAlias(this.serverName);
            builder.setType(PushProtos.PushRequest.PushType.ONE2ONE);
            builder.setQosLevel(PushProtos.PushRequest.QosLevel.valueOf((int)this.privateQosLevel));
            builder.setUnActivePublish(unActivePublish);
        }
        boolean denyAppVerCount = false;
        for (MgsPush.PushPayload payLoad : request.getPayloadList()) {
            if (isAPNS) {
                if (!this.checkIosValidation(mqResponseBuilder, responsePayloadBuilder, payLoad, serverId)) continue;
                mqResponseBuilder.addResPayload(this.sendApnsMessage(responsePayloadBuilder, payLoad, serverId));
                continue;
            }
            if (!isGCM) continue;
            reqAndroidUserMap.put(payLoad.getId() + ":" + serverId, payLoad);
            if (!this.privateService.useRainboots() || !RAINBOOTS_RUN.equals(this.appInfo.getPrivateFlag())) continue;
            PushProtos.PushRequest.Payload.Builder payloadBuilder = PushProtos.PushRequest.Payload.newBuilder();
            String id = payLoad.getId() + ":" + serverId;
            payloadBuilder.setToken(id.split("&&")[1]);
            payloadBuilder.setId(id);
            payloadBuilder.setTimeToLive(payLoad.getGcmMessage().getTimeToLive() > 0 ? payLoad.getGcmMessage().getTimeToLive() : 1800);
            payloadBuilder.setMsgId(0);
            String realTimeRainbootsMsg = this.makeRainbootsMessage(payLoad.getGcmMessage());
            log.debug("realtime rainboots send message : {}", (Object)realTimeRainbootsMsg);
            payloadBuilder.setMessage(realTimeRainbootsMsg);
            builder.addPayload(payloadBuilder.build());
        }
        if (isGCM) {
            long t = System.currentTimeMillis();
            if (this.privateService.useRainboots() && RAINBOOTS_RUN.equals(this.appInfo.getPrivateFlag()) && builder.getPayloadCount() > 0) {
                long startTime = System.currentTimeMillis();
                log.debug("rainboots reqeust : {}", (Object)builder.build());
                List<MgsPush.Response.ResponsePayload> rainbootsResult = this.sendRainboots(responsePayloadBuilder, privateSendingList, reqAndroidUserMap, builder.build(), isGcmReSend, false);
                mqResponseBuilder.addAllResPayload(rainbootsResult);
                log.debug("SEND PUSH RAINBOOTS REQUEST DURATION TIME :{}", (Object)(System.currentTimeMillis() - startTime));
            }
            log.debug("rain t {}", (Object)(System.currentTimeMillis() - t));
            if (reqAndroidUserMap.size() > 0 && isGcmReSend) {
                Collection androidList = reqAndroidUserMap.values();
                try {
                    long startTime = System.currentTimeMillis();
                    if ("http".equalsIgnoreCase(this.gcmType)) {
                        this.gcmHttpMqServiceImpl.setServerId(serverId);
                        List<MgsPush.Response.ResponsePayload> payLoadList = this.gcmHttpMqServiceImpl.sendGcmOne2OneList(androidList, this.appInfo.getGcmApiKey());
                        for (MgsPush.Response.ResponsePayload payloadData : payLoadList) {
                            mqResponseBuilder.addResPayload(payloadData);
                        }
                    } else if ("xmpp".equalsIgnoreCase(this.gcmType)) {
                        for (MgsPush.PushPayload payload : androidList) {
                            String ccsMessage = this.gcmCcsService.makeCcsMessage(payload, this.appInfo.getAppGrpId(), request.getSeverId());
                            try {
                                this.gcmCcsService.sendDownstreamMessage(ccsMessage);
                            }
                            catch (Exception e) {
                                try {
                                    log.error("NotConnectedException in GcmSend (XMPP) retry 1 more: {}", (Object)payload.getId(), (Object)e);
                                    this.gcmCcsService.reset();
                                    this.gcmCcsService.sendDownstreamMessage(ccsMessage);
                                }
                                catch (SmackException.NotConnectedException e2) {
                                    log.error("NotConnectedException in GcmSend (XMPP) Retry Fail: {}", (Object)payload.getId(), (Object)e);
                                    responsePayloadBuilder.clear();
                                    responsePayloadBuilder.setId(payload.getId());
                                    responsePayloadBuilder.setReturnCode(MgsPush.Response.ReturnCode.ERROR_UNAVAILABLE);
                                    mqResponseBuilder.addResPayload(responsePayloadBuilder.build());
                                    this.gcmCcsService.setHitCount(0);
                                    this.gcmCcsService.reset();
                                    continue;
                                }
                            }
                            responsePayloadBuilder.clear();
                            responsePayloadBuilder.setId(payload.getId());
                            responsePayloadBuilder.setReturnCode(MgsPush.Response.ReturnCode.SENDING_CCS);
                            mqResponseBuilder.addResPayload(responsePayloadBuilder.build());
                        }
                    }
                    log.info("send {} [count:{}, elpasedTime:{} ms]", new Object[]{this.gcmType, androidList.size(), System.currentTimeMillis() - startTime});
                }
                catch (Exception e) {
                    log.error("GCM Send Error", (Throwable)e);
                }
            } else if (reqAndroidUserMap.size() > 0) {
                log.error("reqAndroidUserMap size :{} gcmReSendFlag:{}", (Object)reqAndroidUserMap.size(), (Object)isGcmReSend);
                Collection androidList = reqAndroidUserMap.values();
                StringBuilder sb = new StringBuilder();
                for (MgsPush.PushPayload payload : androidList) {
                    responsePayloadBuilder.clear();
                    responsePayloadBuilder.setId(payload.getId());
                    responsePayloadBuilder.setReturnCode(MgsPush.Response.ReturnCode.NO_SEND);
                    mqResponseBuilder.addResPayload(responsePayloadBuilder.build());
                }
            }
        }
        if (isGCM) {
            mqResponseBuilder.setAppKey(this.appInfo.getAppKey("A"));
            mqResponseBuilder.setPushChnType(MgsPush.PushChnType.GCM);
        } else if (isAPNS) {
            mqResponseBuilder.setAppKey(this.appInfo.getAppKey("I"));
            mqResponseBuilder.setPushChnType(MgsPush.PushChnType.APNS);
        }
        if (!privateSendingList.isEmpty()) {
            this.pushResultServiceImpl.batchInsertSendingStatus(privateSendingList, this.appInfo, serverId);
        }
        mqResponseBuilder.setResultCode(MgsPush.Response.ResultCode.SUCCESS);
        try {
            MgsPush.Response t = mqResponseBuilder.build();
            return t;
        }
        catch (Exception e) {
            log.error("mqResponseBuilder make response Fail : {}", (Throwable)e);
            MgsPush.Response response = null;
            return response;
        }
        finally {
            mqResponseBuilder.clear();
        }
    }

    @Override
    public MgsPush.Response request(MgsPush.Request request, PushMessage pushMessage, boolean isGcmReSend) {
        return null;
    }

    @Override
    public MgsPush.Response request(MgsPush.Request request, PushMessage pushMessage, boolean isGcmReSend, boolean unActivePublish) throws Exception {
        return null;
    }

    @Override
    public MgsPush.Response request(MgsPush.Request request, PushMessage pushMessage, boolean isGcmReSend, boolean unActivePublish, boolean useWakeupGcm) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void openApnsConnection(String apnsCertPath, String password, boolean isReal) {
        if (this.pushManager == null) {
            try {
                AppleNotificationServerBasicImpl server = new AppleNotificationServerBasicImpl((Object)apnsCertPath, password, isReal);
                this.pushManager = new PushNotificationManager();
                this.pushManager.initializeConnection((AppleNotificationServer)server);
            }
            catch (Exception e) {
                log.error("error : {}", (Throwable)e);
                try {
                    if (this.pushManager != null) {
                        this.pushManager.stopConnection();
                    }
                }
                catch (Exception e2) {
                    log.error("stop connection error", (Throwable)e2);
                }
                finally {
                    this.pushManager = null;
                }
            }
        }
    }

    protected boolean checkIosValidation(MgsPush.Response.Builder mqResponseBuilder, MgsPush.Response.ResponsePayload.Builder responsePayloadBuilder, MgsPush.PushPayload payLoad, String serverId) {
        boolean isValid = true;
        try {
            new BasicDevice(payLoad.getToken());
        }
        catch (InvalidDeviceTokenFormatException e) {
            isValid = false;
            responsePayloadBuilder.clear();
            responsePayloadBuilder.setId(payLoad.getId());
            responsePayloadBuilder.setReturnCode(MgsPush.Response.ReturnCode.APNS_INVALID_DEVICE_TOKEN_FORMAT_EXCEPTION);
            responsePayloadBuilder.setServerId(serverId);
            mqResponseBuilder.addResPayload(responsePayloadBuilder.build());
        }
        return isValid;
    }

    public synchronized MgsPush.Response.ResponsePayload sendApnsMessage(MgsPush.Response.ResponsePayload.Builder responsePayloadBuilder, MgsPush.PushPayload pushPayload, String serverId) {
        StringBuilder sb = new StringBuilder();
        sb.setLength(0);
        if (this.pushManager == null) {
            responsePayloadBuilder.clear();
            responsePayloadBuilder.setId(pushPayload.getId());
            responsePayloadBuilder.setReturnCode(MgsPush.Response.ReturnCode.APNS_UNKNOWN_ERROR);
            return responsePayloadBuilder.build();
        }
        try {
            String message = pushPayload.getApnsMessage().getMessage();
            String pushKey = pushPayload.getApnsMessage().getPushKey();
            String pushValue = pushPayload.getApnsMessage().getPushValue();
            PushNotificationPayload payload = PushNotificationPayload.alert((String)message);
            if (this.appInfo.getPushSound() == null) {
                payload.addSound("default");
            } else {
                payload.addSound(this.appInfo.getPushSound());
            }
            if (this.appInfo.getIOsBadgeCount() > 0) {
                payload.addBadge(this.appInfo.getIOsBadgeCount());
            }
            payload.addCustomDictionary("t", pushPayload.getApnsMessage().getMsgType());
            payload.addCustomDictionary("i", String.valueOf(pushPayload.getApnsMessage().getMsgId()));
            if (log.isDebugEnabled()) {
                log.debug("apns payload add before size:{} payload:{}", (Object)payload.getPayloadSize(), (Object)payload.toString());
            }
            if (!StringUtils.isNull((String)pushKey) && payload.isEstimatedPayloadSizeAllowedAfterAdding(pushKey, (Object)pushValue)) {
                payload.addCustomDictionary(pushKey, pushValue);
                if (log.isDebugEnabled()) {
                    log.debug("apns payload push key add after size:{} payload:{}", (Object)payload.getPayloadSize(), (Object)payload.toString());
                }
            }
            BasicDevice device = new BasicDevice(pushPayload.getToken());
            PushedNotification notification = this.pushManager.sendNotification((Device)device, (Payload)payload, false);
            String errorCode = null;
            if (notification.isSuccessful()) {
                errorCode = "1000";
            } else {
                errorCode = "1111";
                if (notification.getException() != null) {
                    String[] responseParts = notification.getException().toString().split(":");
                    String err = responseParts[0];
                    log.error("APNS error : {}", (Throwable)notification.getException());
                    if (err.contains("DuplicateDeviceException") || err.contains("InvalidDeviceTokenFormatException")) {
                        errorCode = "1001";
                    } else if (err.contains("NullDeviceTokenException")) {
                        errorCode = "1003";
                    } else if (err.contains("NullIdException")) {
                        errorCode = "1004";
                    } else if (err.contains("UnknownDeviceException")) {
                        errorCode = "1005";
                    } else if (err.contains("PayloadMaxSizeExceededException")) {
                        errorCode = "1009";
                    }
                }
            }
            responsePayloadBuilder.clear();
            responsePayloadBuilder.setId(pushPayload.getId());
            responsePayloadBuilder.setReturnCode(MgsPush.Response.ReturnCode.valueOf((int)Integer.parseInt(errorCode)));
            responsePayloadBuilder.setServerId(serverId);
            return responsePayloadBuilder.build();
        }
        catch (Exception e) {
            log.error("APNS Send Error", (Throwable)e);
            if (e instanceof InvalidDeviceTokenFormatException) {
                responsePayloadBuilder.clear();
                responsePayloadBuilder.setId(pushPayload.getId());
                responsePayloadBuilder.setReturnCode(MgsPush.Response.ReturnCode.APNS_INVALID_DEVICE_TOKEN_FORMAT_EXCEPTION);
                responsePayloadBuilder.setServerId(serverId);
                return responsePayloadBuilder.build();
            }
            responsePayloadBuilder.clear();
            responsePayloadBuilder.setId(pushPayload.getId());
            responsePayloadBuilder.setReturnCode(MgsPush.Response.ReturnCode.APNS_UNKNOWN_ERROR);
            responsePayloadBuilder.setServerId(serverId);
            return responsePayloadBuilder.build();
        }
    }

    protected String makeRainbootsMessage(MgsPush.GcmMessage message) {
        JSONObject messageJson = new JSONObject();
        try {
            messageJson.put((Object)"notiMsg", (Object)StringUtils.validString((String)message.getPushNotiMsg()));
            messageJson.put((Object)"notiTitle", (Object)StringUtils.validString((String)message.getPushNotiTitle()));
            String pushImage = message.getPushNotiImg();
            if (pushImage != null && !pushImage.startsWith("http://") && "http://".length() >= pushImage.length()) {
                pushImage = "";
            }
            messageJson.put((Object)"notiImg", (Object)(pushImage == null ? "" : pushImage));
            messageJson.put((Object)"message", (Object)message.getPushRichContent());
            messageJson.put((Object)"t", (Object)message.getMsgType());
            messageJson.put((Object)"i", (Object)String.valueOf(message.getMsgId()));
            JSONObject json = new JSONObject();
            messageJson.put((Object)"d", (Object)message.getPushData());
        }
        catch (Exception e) {
            log.error("exception in makeRainboots messaage", (Throwable)e);
        }
        return messageJson.toString();
    }

    protected List<MgsPush.Response.ResponsePayload> sendRainboots(MgsPush.Response.ResponsePayload.Builder responsePayloadBuilder, List<MgsPush.PushPayload> privateSendingList, Map<String, MgsPush.PushPayload> androidMap, PushProtos.PushRequest pushRequest, boolean isGcmReSend, boolean useWakeupGcm) {
        long startTime = System.currentTimeMillis();
        PushProtos.PushResponse response = this.privateService.request(pushRequest);
        ArrayList<MgsPush.Response.ResponsePayload> resultList = new ArrayList<MgsPush.Response.ResponsePayload>();
        if (response != null && response.getResult() == PushProtos.PushResponse.ResultType.SUCCESS) {
            log.debug("private server send result : {}", (Object)response.toString());
            int payloadSize = response.getPayloadCount();
            for (int i = payloadSize - 1; i >= 0; --i) {
                MgsPush.PushPayload pushPayload = androidMap.get(response.getPayload(i).getId());
                if (response.getPayload(i).getResult() == PushProtos.PushResponse.ResultType.SUCCESS) {
                    responsePayloadBuilder.clear();
                    responsePayloadBuilder.setId(response.getPayload(i).getId());
                    responsePayloadBuilder.setReturnCode(MgsPush.Response.ReturnCode.SENDING);
                    resultList.add(responsePayloadBuilder.build());
                    androidMap.remove(response.getPayload(i).getId());
                    privateSendingList.add(pushPayload);
                } else if (!isGcmReSend) {
                    responsePayloadBuilder.clear();
                    responsePayloadBuilder.setId(response.getPayload(i).getId());
                    if (response.getPayload(i).getResult() == PushProtos.PushResponse.ResultType.UNACTIVED_TOKEN) {
                        responsePayloadBuilder.setReturnCode(MgsPush.Response.ReturnCode.PRIVATE_UNACTIVED_TOKEN);
                    } else if (response.getPayload(i).getResult() == PushProtos.PushResponse.ResultType.INVALID_TOKEN) {
                        responsePayloadBuilder.setReturnCode(MgsPush.Response.ReturnCode.PRIVATE_INVALID_TOKEN);
                    }
                    resultList.add(responsePayloadBuilder.build());
                    androidMap.remove(response.getPayload(i).getId());
                }
                if (!log.isDebugEnabled()) continue;
                log.debug("return code : {}", (Object)response.getPayload(i).toString());
            }
            long rainbootsElapsedTime = System.currentTimeMillis() - startTime;
            log.info("rainboots send [sendCount:{}, elapsedTime:{}]", (Object)pushRequest.getPayloadCount(), (Object)rainbootsElapsedTime);
            if (useWakeupGcm) {
                this.sendWakeupGcm(pushRequest, androidMap);
            }
        } else {
            log.info("private server send fail result : {}", (Object)(response == null ? "null" : response.getResult().toString()));
            if (!isGcmReSend) {
                Set<String> sendRawIdSet = androidMap.keySet();
                for (String ids : sendRawIdSet) {
                    MgsPush.PushPayload payLoad = androidMap.get(ids);
                    responsePayloadBuilder.clear();
                    responsePayloadBuilder.setId(payLoad.getId());
                    responsePayloadBuilder.setReturnCode(MgsPush.Response.ReturnCode.PRIVATE_SERVER_ERROR);
                    resultList.add(responsePayloadBuilder.build());
                }
                androidMap.clear();
            }
        }
        return resultList;
    }

    protected void sendWakeupGcm(PushProtos.PushRequest pushRequest, Map<String, MgsPush.PushPayload> androidMap) {
        long startTime = System.currentTimeMillis();
        Collection<MgsPush.PushPayload> wakeupGcmList = androidMap.values();
        MgsPush.PushPayload[] wakeupSendRaw = new MgsPush.PushPayload[wakeupGcmList.size()];
        wakeupGcmList.toArray(wakeupSendRaw);
        Message.Builder builder = new Message.Builder();
        builder.timeToLive(180);
        builder.delayWhileIdle(false);
        this.gcmHttpMqServiceImpl.sendGcmMulticastMessage((MgsPush.PushPayload[])wakeupSendRaw, builder.build(), this.appInfo.getGcmApiKey());
        long gcmWakeUpPushElapsedTime = System.currentTimeMillis() - startTime;
        log.info("gcm wakeup push count : {} elapsedTime : {}", (Object)pushRequest.getPayloadCount(), (Object)gcmWakeUpPushElapsedTime);
    }
}

