/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.batch.service.impl;

import com.humuson.tms.batch.domain.App;
import com.humuson.tms.batch.domain.PushMessage;
import com.humuson.tms.batch.service.MqMDP;
import com.humuson.tms.batch.service.MqProducer;
import com.humuson.tms.batch.service.PushInfoService;
import com.humuson.tms.batch.service.PushSendService;
import com.humuson.tms.batch.service.impl.MqPushSendServiceImpl;
import com.humuson.tms.mq.model.MgsPush;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;

public class MqAutoRequestMDP
implements MqMDP<MgsPush.Request> {
    private static final Logger log = LoggerFactory.getLogger(MqAutoRequestMDP.class);
    @Autowired
    protected PushInfoService<App, PushMessage> pushInfoService;
    @Autowired
    @Qualifier(value="mqReqProducer")
    private MqProducer mqReqProducer;
    @Autowired
    @Qualifier(value="mqAutoResProducer")
    private MqProducer mqAutoResProducer;
    @Value(value="#{config['use.resend.gcm.for.private.failed']}")
    private boolean useResendGcm;
    @Value(value="#{config['tms.private.inactive.publish']}")
    private boolean privateInactivePublish;
    @Value(value="#{config['sending.status.mq.response.insert']}")
    protected boolean isSendDataInsert;
    @Value(value="#{config['send.gcm.type']}")
    protected String gcmType;
    @Autowired
    private AutowireCapableBeanFactory beanFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleMessage(MgsPush.Request request) {
        if (log.isDebugEnabled()) {
            log.debug("requestMDP : {}", (Object)request.toString());
        }
        String appKey = request.getAppKey();
        boolean isAPNS = MgsPush.PushChnType.APNS.equals((Object)request.getPushChnType());
        MgsPush.Response response = null;
        PushSendService mqPushSendService = (PushSendService)this.beanFactory.getBean(MqPushSendServiceImpl.class);
        try {
            mqPushSendService.init(this.pushInfoService.getAppInfoByAppKey(appKey).setReqPushChnType(request.getPushChnType()));
            response = (MgsPush.Response)mqPushSendService.request(request, this.useResendGcm, this.privateInactivePublish);
        }
        catch (Exception e) {
            log.error("Error! Push Request Send : {}", (Throwable)e);
        }
        finally {
            try {
                mqPushSendService.close();
            }
            catch (Exception e) {}
        }
        try {
            if (("XMPP".equalsIgnoreCase(this.gcmType) && this.isSendDataInsert || isAPNS || "http".equalsIgnoreCase(this.gcmType)) && log.isDebugEnabled()) {
                log.debug("RESPONSE : {}", (Object)response.toString());
            }
        }
        catch (Exception e) {
            log.error("Error! Push Response Insert Mq : {}", (Throwable)e);
            log.error("Error! Push Response Insert Retry / Que Name : ", (Object)this.mqAutoResProducer.getDefaultDestination());
        }
    }
}

