/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.batch.service.impl;

import com.humuson.tms.batch.domain.App;
import com.humuson.tms.batch.domain.PushMessage;
import com.humuson.tms.batch.domain.PushResult;
import com.humuson.tms.batch.service.MqMDP;
import com.humuson.tms.batch.service.PushInfoService;
import com.humuson.tms.batch.service.PushResultService;
import com.humuson.tms.mq.model.MgsPush;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class MgsResponseMDP
implements MqMDP<MgsPush.Response> {
    private static final Logger log = LoggerFactory.getLogger(MgsResponseMDP.class);
    @Autowired
    private PushResultService pushResultService;
    @Autowired
    protected PushInfoService<App, PushMessage> pushInfoService;

    @Override
    public void handleMessage(MgsPush.Response response) {
        if (log.isDebugEnabled()) {
            log.debug("resonseMDP : {}", (Object)response.toString());
        }
        List list = response.getResPayloadList();
        App app = this.pushInfoService.getAppInfoByAppKey(response.getAppKey());
        ArrayList<PushResult> resList = new ArrayList<PushResult>();
        String os = "A";
        if (response.getPushChnType() == MgsPush.PushChnType.APNS) {
            os = "I";
        }
        for (MgsPush.Response.ResponsePayload resPayload : list) {
            resList.add(new PushResult(app.getAppGrpId(), String.valueOf(resPayload.getReturnCode().getNumber()), resPayload.getId(), os, null));
        }
        this.pushResultService.batchUpdatePushResult(resList);
    }
}

