/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.batch.service.impl;

import com.humuson.rainboots.proto.messages.PushProtos;
import com.humuson.tms.batch.domain.App;
import com.humuson.tms.batch.domain.PushMessage;
import com.humuson.tms.batch.domain.PushQueue;
import com.humuson.tms.batch.domain.PushResult;
import com.humuson.tms.batch.service.MqProducer;
import com.humuson.tms.batch.service.impl.PushSendServiceImpl;
import com.humuson.tms.common.util.StringUtils;
import com.humuson.tms.mq.model.MgsPush;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.simple.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class MgsPushSendServiceImpl
extends PushSendServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(MgsPushSendServiceImpl.class);
    @Autowired
    private MqProducer mgsProducer;
    @Value(value="#{config['use.mgs.public.push']}")
    protected boolean useMgsPublicPush;

    public MgsPushSendServiceImpl() {
        log.debug("MQPushSendServiceImpl :{} instance generate hashCode:{}", (Object)this.serverName, (Object)this.hashCode());
    }

    public MgsPushSendServiceImpl(String serverName) {
        super(serverName);
    }

    @Override
    public synchronized void init(App appInfo) {
        if (!this.useMgsPublicPush) {
            super.init(appInfo);
        } else {
            String[] denyAppVersions;
            this.appInfo = appInfo;
            for (String denyAppVer : denyAppVersions = appInfo.getDenyAppVersion().split(",")) {
                this.denyAppVersionMap.put(denyAppVer, true);
            }
        }
    }

    @Override
    public void close() {
        if (!this.useMgsPublicPush) {
            super.close();
        }
    }

    @Override
    public List<PushResult> request(List<? extends PushQueue> list, boolean isGcmReSend, boolean unActivePublish, boolean useWakeupGcm) {
        if (!this.useMgsPublicPush) {
            return super.request(list, isGcmReSend, unActivePublish, useWakeupGcm);
        }
        HashMap<String, PushQueue> reqAndroidUserMap = new HashMap<String, PushQueue>();
        ArrayList<PushResult> pushResultList = new ArrayList<PushResult>();
        PushProtos.PushRequest.Builder builder = PushProtos.PushRequest.newBuilder();
        String androidAppKey = this.appInfo.getAppKey("A");
        if (this.privateService.useRainboots() && !StringUtils.isNull((String)androidAppKey) && "Y".equals(this.appInfo.getPrivateFlag())) {
            builder.setAppkey(androidAppKey);
            builder.setAlias(this.serverName);
            builder.setType(PushProtos.PushRequest.PushType.ONE2ONE);
            builder.setQosLevel(PushProtos.PushRequest.QosLevel.valueOf((int)this.privateQosLevel));
            builder.setUnActivePublish(unActivePublish);
        }
        int denyAppVerCount = 0;
        MgsPush.Request.Builder gcmRequestBuilder = null;
        MgsPush.Request.Builder apnsRequestBuilder = null;
        if (this.appInfo.getAppKey("A") != null) {
            gcmRequestBuilder = MgsPush.Request.newBuilder().setAppKey(this.appInfo.getAppKey("A")).setAckMode(MgsPush.Request.AckMode.ACK).setPushChnType(MgsPush.PushChnType.GCM).setSendType(MgsPush.Request.SendType.ONE2ONE);
        }
        if (this.appInfo.getAppKey("I") != null) {
            apnsRequestBuilder = MgsPush.Request.newBuilder().setAppKey(this.appInfo.getAppKey("I")).setAckMode(MgsPush.Request.AckMode.ACK).setPushChnType(MgsPush.PushChnType.APNS).setSendType(MgsPush.Request.SendType.ONE2ONE);
        }
        MgsPush.PushPayload.Builder pushPayloadBuilder = MgsPush.PushPayload.newBuilder();
        StringBuilder sb = new StringBuilder();
        String id = null;
        for (PushQueue pushQueue : list) {
            sb.setLength(0);
            id = sb.append(pushQueue.getPushId()).append("&&").append(pushQueue.getDeviceId()).append("&&").append(pushQueue.getReqUid()).append("&&").append(pushQueue.getCustId()).toString();
            pushPayloadBuilder.clear();
            PushResult pushResult = this.checkValidation(pushQueue, this.appInfo.getOs(pushQueue.getAppId()));
            if (pushResult != null) {
                pushResultList.add(pushResult);
                continue;
            }
            if ("I".equals(this.appInfo.getOs(pushQueue.getAppId()))) {
                pushPayloadBuilder.setToken(pushQueue.getPushToken()).setId(id).setApnsMessage(this.makeApnsMqMessage(pushQueue.getPushMessage()));
                if (apnsRequestBuilder != null) {
                    apnsRequestBuilder.addPayload(pushPayloadBuilder.build());
                }
                pushResultList.add(new PushResult(this.appInfo.getAppGrpId(), "3001", id, "I", pushQueue.getRowId()));
                continue;
            }
            PushProtos.PushRequest.Payload.Builder payloadBuilder = PushProtos.PushRequest.Payload.newBuilder();
            if (this.privateService.useRainboots() && "Y".equals(this.appInfo.getPrivateFlag())) {
                payloadBuilder.setId(id);
                payloadBuilder.setToken(String.valueOf(pushQueue.getDeviceId()));
                payloadBuilder.setTimeToLive(pushQueue.getPushMessage().getPushTtl());
                payloadBuilder.setMsgId(0);
                String realTimeRainbootsMsg = this.makeRainbootsMessage(pushQueue.getPushMessage());
                log.debug("realtime rainboots send message : {}", (Object)realTimeRainbootsMsg);
                payloadBuilder.setMessage(realTimeRainbootsMsg);
                builder.addPayload(payloadBuilder.build());
            }
            reqAndroidUserMap.put(pushQueue.getPushId() + "_" + pushQueue.getDeviceId(), pushQueue);
        }
        if (denyAppVerCount > 0) {
            log.info("deny app version filter count : {}", (Object)denyAppVerCount);
        }
        if (reqAndroidUserMap.size() > 0) {
            Collection androidList;
            if (this.privateService.useRainboots() && "Y".equals(this.appInfo.getPrivateFlag()) && builder.getPayloadCount() > 0) {
                long startTime = System.currentTimeMillis();
                if (log.isDebugEnabled()) {
                    log.debug("rainboots reqeust : {}", (Object)builder.build());
                }
                List<PushResult> rainbootsResult = this.sendRainboots(reqAndroidUserMap, builder.build(), isGcmReSend, false);
                pushResultList.addAll(rainbootsResult);
                if (log.isDebugEnabled()) {
                    log.debug("SEND PUSH RAINBOOTS REQUEST DURATION TIME :{}", (Object)(System.currentTimeMillis() - startTime));
                }
            }
            if (!reqAndroidUserMap.isEmpty() && isGcmReSend) {
                androidList = reqAndroidUserMap.values();
                for (PushQueue gcmPushQueue : androidList) {
                    sb.setLength(0);
                    id = sb.append(gcmPushQueue.getPushId()).append("&&").append(gcmPushQueue.getDeviceId()).append("&&").append(gcmPushQueue.getReqUid()).append("&&").append(gcmPushQueue.getCustId()).toString();
                    pushPayloadBuilder.setId(id).setToken(gcmPushQueue.getPushToken()).setGcmMessage(this.makeGcmMqMessage(gcmPushQueue.getPushMessage()));
                    if (gcmRequestBuilder != null) {
                        gcmRequestBuilder.addPayload(pushPayloadBuilder.build());
                    }
                    pushResultList.add(new PushResult(this.appInfo.getAppGrpId(), "3001", id, "A", gcmPushQueue.getRowId()));
                }
            } else if (reqAndroidUserMap.size() > 0) {
                log.error("reqAndroidUserMap size :{} gcmReSendFlag:{}", (Object)reqAndroidUserMap.size(), (Object)isGcmReSend);
                androidList = reqAndroidUserMap.values();
                for (PushQueue pushQueue : androidList) {
                    sb.setLength(0);
                    id = sb.append(pushQueue.getPushId()).append("&&").append(pushQueue.getDeviceId()).append("&&").append(pushQueue.getReqUid()).append("&&").append(pushQueue.getCustId()).toString();
                    pushResultList.add(new PushResult(this.appInfo.getAppGrpId(), "8000", id, "A", pushQueue.getRowId()));
                }
            }
        }
        if (apnsRequestBuilder != null && !apnsRequestBuilder.getPayloadList().isEmpty()) {
            log.info("mgs apns public push send [payloadSize:{}, payload:{}]", (Object)apnsRequestBuilder.getPayloadList().size(), (Object)apnsRequestBuilder.build().toString());
            this.mgsProducer.send(apnsRequestBuilder.build());
        }
        if (gcmRequestBuilder != null && !gcmRequestBuilder.getPayloadList().isEmpty()) {
            log.info("mgs gcm public push send [payloadSize:{}]", (Object)gcmRequestBuilder.getPayloadList().size());
            this.mgsProducer.send(gcmRequestBuilder.build());
        }
        return pushResultList;
    }

    private MgsPush.ApnsMessage makeApnsMqMessage(PushMessage pushMessage) {
        MgsPush.ApnsMessage.Builder apnsMsgBuilder = MgsPush.ApnsMessage.newBuilder();
        apnsMsgBuilder.setMessage(pushMessage.getPushTitle() + "\n" + pushMessage.getPushMsg()).setSound(StringUtils.validString((String)this.appInfo.getPushSound())).setMsgType(pushMessage.getMsgType()).setMsgId(String.valueOf(pushMessage.getMsgUid()));
        if (!StringUtils.isNull((String)pushMessage.getPushKey())) {
            apnsMsgBuilder.setPushKey(pushMessage.getPushKey()).setPushValue(StringUtils.validString((String)pushMessage.getPushValue()));
        }
        return apnsMsgBuilder.build();
    }

    private MgsPush.GcmMessage makeGcmMqMessage(PushMessage pushMessage) {
        MgsPush.GcmMessage.Builder gcmMsgBuilder = MgsPush.GcmMessage.newBuilder();
        gcmMsgBuilder.setTimeToLive(pushMessage.getPushTtl()).setDelayWhileIdle(false).setPushNotiMsg(StringUtils.validString((String)pushMessage.getPushMsg())).setPushRichContent(StringUtils.validString((String)pushMessage.getPopupContent())).setPushNotiTitle(StringUtils.validString((String)pushMessage.getPushTitle())).setPushNotiImg(StringUtils.validString((String)pushMessage.getPushImg())).setMsgType(pushMessage.getMsgType()).setMsgId(pushMessage.getMsgUid());
        JSONObject json = new JSONObject();
        if (!StringUtils.isNull((String)pushMessage.getPushKey())) {
            json.put((Object)pushMessage.getPushKey(), (Object)StringUtils.validString((String)pushMessage.getPushValue()));
        }
        gcmMsgBuilder.setPushData(json.toString());
        return gcmMsgBuilder.build();
    }

    @Override
    public List<PushResult> request(List<? extends PushQueue> list, PushMessage pushMessage, boolean isGcmReSend, boolean unActivePublish, boolean useWakeupGcm) {
        if (!this.useMgsPublicPush) {
            return super.request(list, pushMessage, isGcmReSend, unActivePublish, useWakeupGcm);
        }
        HashMap<String, PushQueue> reqAndroidUserMap = new HashMap<String, PushQueue>();
        ArrayList<PushResult> pushResultList = new ArrayList<PushResult>();
        PushProtos.PushRequest.Builder privateReqBuilder = PushProtos.PushRequest.newBuilder();
        if (this.privateService.useRainboots() && this.appInfo.getAppKey("A") != null && "Y".equals(this.appInfo.getPrivateFlag())) {
            privateReqBuilder.setAppkey(this.appInfo.getAppKey("A"));
            privateReqBuilder.setAlias(this.serverName);
            privateReqBuilder.setType(PushProtos.PushRequest.PushType.BROADCAST);
            privateReqBuilder.setMsgId((int)(Long.parseLong(pushMessage.getMsgUid()) % 32767L));
            privateReqBuilder.setQosLevel(PushProtos.PushRequest.QosLevel.valueOf((int)this.privateQosLevel));
            privateReqBuilder.setUnActivePublish(unActivePublish);
            if (pushMessage.getPushTtl() > 0) {
                privateReqBuilder.setTimeToLive(pushMessage.getPushTtl());
            }
            String rainbootsBulkMsg = this.makeRainbootsMessage(pushMessage);
            privateReqBuilder.setMessage(rainbootsBulkMsg);
        }
        MgsPush.Request.Builder mgsGcmRequestBuilder = null;
        MgsPush.Request.Builder apnsRequestBuilder = null;
        if (this.appInfo.getAppKey("A") != null) {
            mgsGcmRequestBuilder = MgsPush.Request.newBuilder().setAppKey(this.appInfo.getAppKey("A")).setAckMode(MgsPush.Request.AckMode.ACK).setSendType(MgsPush.Request.SendType.MULTICAST).setGcmMessage(this.makeGcmMqMessage(pushMessage)).setPushChnType(MgsPush.PushChnType.GCM);
        }
        if (this.appInfo.getAppKey("I") != null) {
            apnsRequestBuilder = MgsPush.Request.newBuilder().setAppKey(this.appInfo.getAppKey("I")).setAckMode(MgsPush.Request.AckMode.ACK).setSendType(MgsPush.Request.SendType.MULTICAST).setApnsMessage(this.makeApnsMqMessage(pushMessage)).setPushChnType(MgsPush.PushChnType.APNS);
        }
        MgsPush.PushPayload.Builder mgsPublicPayloadBuilder = MgsPush.PushPayload.newBuilder();
        StringBuilder sb = new StringBuilder();
        String id = null;
        for (PushQueue pushQueue : list) {
            mgsPublicPayloadBuilder.clear();
            sb.setLength(0);
            id = sb.append(pushQueue.getPushId()).append("&&").append(pushQueue.getDeviceId()).append("&&").append(pushQueue.getReqUid()).append("&&").append(pushQueue.getCustId()).toString();
            PushResult pushResult = this.checkValidation(pushQueue, this.appInfo.getOs(pushQueue.getAppId()));
            if (pushResult != null) {
                pushResultList.add(pushResult);
                continue;
            }
            mgsPublicPayloadBuilder.clear();
            if ("I".equals(this.appInfo.getOs(pushQueue.getAppId()))) {
                if (apnsRequestBuilder != null) {
                    apnsRequestBuilder.addPayload(mgsPublicPayloadBuilder.setId(id).setToken(pushQueue.getPushToken()).build());
                }
                pushResultList.add(new PushResult(this.appInfo.getAppGrpId(), "3001", id, "I", pushQueue.getRowId()));
                continue;
            }
            reqAndroidUserMap.put(pushQueue.getPushId() + "_" + pushQueue.getDeviceId(), pushQueue);
            if (!this.privateService.useRainboots() || !"Y".equals(this.appInfo.getPrivateFlag())) continue;
            PushProtos.PushRequest.Payload.Builder payloadBuilder = PushProtos.PushRequest.Payload.newBuilder();
            payloadBuilder.setId(id).setToken(String.valueOf(pushQueue.getDeviceId()));
            privateReqBuilder.addPayload(payloadBuilder.build());
        }
        if (!reqAndroidUserMap.isEmpty()) {
            Collection androidList;
            if (this.privateService.useRainboots() && "Y".equals(this.appInfo.getPrivateFlag()) && privateReqBuilder.getPayloadCount() > 0) {
                long startTime = System.currentTimeMillis();
                List<PushResult> rainbootsResult = this.sendRainboots(reqAndroidUserMap, privateReqBuilder.build(), isGcmReSend, useWakeupGcm);
                pushResultList.addAll(rainbootsResult);
                log.info("send rainboots [size:{}, elapseTime:{}]", (Object)reqAndroidUserMap.size(), (Object)(System.currentTimeMillis() - startTime));
            }
            if (isGcmReSend) {
                androidList = reqAndroidUserMap.values();
                for (PushQueue pushQueue : androidList) {
                    sb.setLength(0);
                    id = sb.append(pushQueue.getPushId()).append("&&").append(pushQueue.getDeviceId()).append("&&").append(pushQueue.getReqUid()).append("&&").append(pushQueue.getCustId()).toString();
                    mgsPublicPayloadBuilder.clear();
                    mgsPublicPayloadBuilder.setId(id).setToken(pushQueue.getPushToken());
                    if (mgsGcmRequestBuilder != null) {
                        mgsGcmRequestBuilder.addPayload(mgsPublicPayloadBuilder.build());
                    }
                    pushResultList.add(new PushResult(this.appInfo.getAppGrpId(), "3001", id, "A", pushQueue.getRowId()));
                }
            } else if (!reqAndroidUserMap.isEmpty()) {
                log.error("reqAndroidUserMap size :{} reqAndroidUserMap.values():{}, gcmReSendFlag:{}", new Object[]{reqAndroidUserMap.size(), reqAndroidUserMap.values().size(), isGcmReSend});
                androidList = reqAndroidUserMap.values();
                for (PushQueue pushQueue : androidList) {
                    sb.setLength(0);
                    id = sb.append(pushQueue.getPushId()).append("&&").append(pushQueue.getDeviceId()).append("&&").append(pushQueue.getReqUid()).append("&&").append(pushQueue.getCustId()).toString();
                    pushResultList.add(new PushResult(this.appInfo.getAppGrpId(), "8000", id, "A", pushQueue.getRowId()));
                }
            }
        }
        if (apnsRequestBuilder != null && !apnsRequestBuilder.getPayloadList().isEmpty()) {
            log.info("mgs apns public push send [payloadSize:{}]", (Object)apnsRequestBuilder.getPayloadList().size());
            this.mgsProducer.send(apnsRequestBuilder.build());
        }
        if (mgsGcmRequestBuilder != null && !mgsGcmRequestBuilder.getPayloadList().isEmpty()) {
            log.info("mgs gcm public push send [payloadSize:{}]", (Object)mgsGcmRequestBuilder.getPayloadList().size());
            this.mgsProducer.send(mgsGcmRequestBuilder.build());
        }
        return pushResultList;
    }

    @Override
    protected void sendWakeupGcm(PushProtos.PushRequest pushRequest, Map<String, PushQueue> androidMap) {
        if (this.useMgsPublicPush) {
            super.sendWakeupGcm(pushRequest, androidMap);
        } else {
            long startTime = System.currentTimeMillis();
            Collection<PushQueue> wakeupGcmList = androidMap.values();
            MgsPush.Request.Builder wakeupRequestBuilder = MgsPush.Request.newBuilder().setAppKey(this.appInfo.getAppKey("A")).setAckMode(MgsPush.Request.AckMode.NOACK).setSendType(MgsPush.Request.SendType.MULTICAST).setPushChnType(MgsPush.PushChnType.GCM);
            MgsPush.PushPayload.Builder payloadBuilder = MgsPush.PushPayload.newBuilder();
            for (PushQueue wakeUpQueue : wakeupGcmList) {
                payloadBuilder.clear();
                wakeupRequestBuilder.addPayload(payloadBuilder.setId(String.valueOf(wakeUpQueue.getPushId())).setToken(wakeUpQueue.getPushToken()).build());
            }
            if (!wakeupRequestBuilder.getPayloadList().isEmpty()) {
                log.info("mgs gcm wakeup public push send [payloadSize:{}]", (Object)wakeupRequestBuilder.getPayloadList().size());
                this.mgsProducer.send(wakeupRequestBuilder.build());
            }
            long gcmWakeUpPushElapsedTime = System.currentTimeMillis() - startTime;
            log.info("gcm wakeup push count : {} elapsedTime : {}", (Object)pushRequest.getPayloadCount(), (Object)gcmWakeUpPushElapsedTime);
        }
    }
}

