/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.batch.service.impl;

import com.humuson.tms.mq.model.MgsPush;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jms.support.converter.MessageConversionException;
import org.springframework.jms.support.converter.MessageConverter;

public abstract class MgsPushMessageConvert<T>
implements MessageConverter {
    private static final Logger log = LoggerFactory.getLogger(MgsPushMessageConvert.class);

    public Message toMessage(Object object, Session session) throws JMSException, MessageConversionException {
        BytesMessage byteMessage = session.createBytesMessage();
        if (object instanceof MgsPush.Request) {
            byteMessage.writeBytes(((MgsPush.Request)object).toByteArray());
        } else if (object instanceof MgsPush.Response) {
            byteMessage.writeBytes(((MgsPush.Response)object).toByteArray());
        } else if (object instanceof MgsPush.ApnsFeedback) {
            byteMessage.writeBytes(((MgsPush.ApnsFeedback)object).toByteArray());
        }
        return byteMessage;
    }

    public Object fromMessage(Message message) throws JMSException, MessageConversionException {
        if (!(message instanceof BytesMessage)) {
            log.error("messaget convert error");
            throw new MessageConversionException("not MapMessage");
        }
        Object t = null;
        if (message instanceof BytesMessage) {
            BytesMessage byteMessage = (BytesMessage)message;
            byte[] data = new byte[(int)byteMessage.getBodyLength()];
            byteMessage.readBytes(data);
            try {
                t = this.parseByteMessage(data);
            }
            catch (Exception e) {
                log.error("MgsPush parse error", (Throwable)e);
            }
        }
        return t;
    }

    protected abstract T parseByteMessage(byte[] var1);
}

