/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.batch.service.impl;

import com.humuson.tms.batch.domain.ApnsFeedback;
import com.humuson.tms.batch.domain.App;
import com.humuson.tms.batch.domain.PushMessage;
import com.humuson.tms.batch.service.AppUserRemover;
import com.humuson.tms.batch.service.MqMDP;
import com.humuson.tms.batch.service.PushInfoService;
import com.humuson.tms.mq.model.MgsPush;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class MgsApnsFeedbackMDP
implements MqMDP<MgsPush.ApnsFeedback> {
    private static final Logger log = LoggerFactory.getLogger(MgsApnsFeedbackMDP.class);
    @Autowired
    private PushInfoService<App, PushMessage> pushInfoServiceImpl;
    @Autowired
    protected AppUserRemover appUserRemover;

    @Override
    public void handleMessage(MgsPush.ApnsFeedback feedback) {
        if (log.isDebugEnabled()) {
            log.debug("response :{}", (Object)feedback.toString());
        }
        String appKey = feedback.getAppKey();
        int appGrpId = this.pushInfoServiceImpl.getAppGrpIdByAppKey(appKey);
        List removedTokenList = feedback.getTokenList();
        ArrayList<ApnsFeedback> apnsFeedbackList = new ArrayList<ApnsFeedback>();
        for (String token : removedTokenList) {
            apnsFeedbackList.add(new ApnsFeedback(appGrpId, token));
        }
        try {
            this.appUserRemover.updateIosUnActiveToken(apnsFeedbackList);
        }
        catch (Exception e) {
            log.error("apns Feedback update error [{}]", (Throwable)e);
            for (ApnsFeedback apnsFeedback : apnsFeedbackList) {
                try {
                    this.appUserRemover.updateIosUnActiveToken(apnsFeedback);
                }
                catch (Exception e2) {
                    log.error("apns Feedback update error [appGrpId:{}, uuid:{}, msg:{}]", new Object[]{apnsFeedback.getGrpId(), apnsFeedback.getUuid(), e.getMessage()});
                }
            }
        }
    }
}

