/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.batch.service.impl;

import com.google.android.gcm.server.Message;
import com.google.android.gcm.server.MulticastResult;
import com.google.android.gcm.server.Result;
import com.google.android.gcm.server.Sender;
import com.humuson.tms.batch.domain.App;
import com.humuson.tms.batch.domain.PushMessage;
import com.humuson.tms.batch.domain.PushQueue;
import com.humuson.tms.batch.domain.PushResult;
import com.humuson.tms.batch.service.GcmHttpService;
import com.humuson.tms.common.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.json.simple.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GcmHttpServiceImpl
implements GcmHttpService<PushResult, PushQueue> {
    private static final Logger log = LoggerFactory.getLogger(GcmHttpServiceImpl.class);
    ConcurrentHashMap<String, Sender> gcmSenderConcurrentMap = new ConcurrentHashMap();
    public static Map<String, String> GCM_ERROR_CODE_MAP = new ConcurrentHashMap<String, String>();
    public App appInfo;

    @Override
    public PushResult sendGcmMessage(PushQueue pushQueue, String gcmApiKey) {
        Message gcmMessage = this.makeGcmMessage(pushQueue);
        Result result = null;
        try {
            result = this.gcmSenderConcurrentMap.get(gcmApiKey).send(gcmMessage, pushQueue.getPushToken(), 3);
        }
        catch (Exception e) {
            log.error("exception in realtime send gcm : {}", (Throwable)e);
        }
        return this.getGcmResult(result, pushQueue);
    }

    public List<PushResult> sendGcmMulticastMessage(PushQueue[] rawUser, Message msg, String gcmApiKey) {
        Message message = msg == null ? this.makeGcmMessage(rawUser[0]) : msg;
        MulticastResult multicastResult = null;
        ArrayList<String> partialDevices = new ArrayList<String>();
        for (PushQueue user : rawUser) {
            if (StringUtils.isNull((String)user.getPushToken())) {
                log.error("GCM empty token is {}", (Object)user.getDeviceId());
                continue;
            }
            partialDevices.add(user.getPushToken());
        }
        try {
            multicastResult = this.gcmSenderConcurrentMap.get(gcmApiKey).send(message, partialDevices, 1);
        }
        catch (Exception e) {
            log.error("multicate send gcm error", (Throwable)e);
            multicastResult = null;
        }
        ArrayList<PushResult> resultList = new ArrayList<PushResult>();
        if (multicastResult != null) {
            List<Result> results = multicastResult.getResults();
            int size = results.size();
            for (int i = 0; i < size; ++i) {
                resultList.add(this.getGcmResult(results.get(i), rawUser[i]));
            }
        } else {
            StringBuilder sb = new StringBuilder();
            for (PushQueue user : rawUser) {
                sb.setLength(0);
                sb.append(user.getPushId()).append("&&").append(user.getDeviceId()).append("&&").append(user.getReqUid()).append("&&").append(user.getCustId()).toString();
                resultList.add(new PushResult(this.appInfo.getAppGrpId(), "4000", sb.toString(), "A", user.getRowId()));
            }
        }
        return resultList;
    }

    @Override
    public PushResult getGcmResult(Result result, PushQueue user) {
        String changedToken = null;
        String resultCode = "1000";
        StringBuilder sb = new StringBuilder();
        String id = sb.append(user.getPushId()).append("&&").append(user.getDeviceId()).append("&&").append(user.getReqUid()).append("&&").append(user.getCustId()).toString();
        if (result == null) {
            return new PushResult(this.appInfo.getAppGrpId(), "2009", id, "A", user.getRowId()).setChangedToken(changedToken);
        }
        String messageId = result.getMessageId();
        if (messageId != null) {
            if (result.getCanonicalRegistrationId() != null) {
                changedToken = result.getCanonicalRegistrationId();
                resultCode = "0000";
            }
        } else {
            String error = result.getErrorCodeName();
            if (GCM_ERROR_CODE_MAP.containsKey(result.getErrorCodeName())) {
                resultCode = GCM_ERROR_CODE_MAP.get(error);
            } else {
                resultCode = "2009";
                log.error("gcm response is unavaliable : {}", (Object)result.toString());
            }
        }
        return new PushResult(this.appInfo.getAppGrpId(), resultCode, id, "A", user.getRowId()).setChangedToken(changedToken);
    }

    @Override
    public void init(App appInfo) {
        this.appInfo = appInfo;
        this.appInfo = appInfo;
        if (this.gcmSenderConcurrentMap.get(appInfo.getGcmApiKey()) == null) {
            Sender sender = new Sender(appInfo.getGcmApiKey());
            this.gcmSenderConcurrentMap.put(appInfo.getGcmApiKey(), sender);
        }
    }

    @Override
    public Message makeGcmMessage(PushQueue que) {
        PushMessage pushMessage = que.getPushMessage();
        Message.Builder builder = new Message.Builder();
        builder.addData("notiMsg", pushMessage.getPushMsg());
        builder.addData("notiTitle", StringUtils.validString((String)pushMessage.getPushTitle()));
        String pushImage = pushMessage.getPushImg();
        if (pushImage != null && !pushImage.startsWith("http://") && "http://".length() >= pushImage.length()) {
            pushImage = "";
        }
        builder.addData("notiImg", pushImage == null ? "" : pushImage);
        builder.addData("message", pushMessage.getPopupContent());
        builder.addData("t", pushMessage.getMsgType());
        builder.addData("i", String.valueOf(pushMessage.getMsgUid()));
        JSONObject json = new JSONObject();
        if (!StringUtils.isNull((String)pushMessage.getPushKey())) {
            json.put((Object)pushMessage.getPushKey(), (Object)StringUtils.validString((String)pushMessage.getPushValue()));
        }
        builder.addData("d", json.toString());
        builder.delayWhileIdle(false);
        log.info("gcm message [{}]", (Object)builder.build().toString());
        return builder.build();
    }

    @Override
    public List<PushResult> sendGcmOne2OneList(Collection<PushQueue> pushQueueCollection, String gcmApiKey) {
        ArrayList<PushResult> resList = new ArrayList<PushResult>();
        Sender sender = this.gcmSenderConcurrentMap.get(gcmApiKey);
        for (PushQueue pushQueue : pushQueueCollection) {
            Message gcmMessage = this.makeGcmMessage(pushQueue);
            Result result = null;
            try {
                result = sender.send(gcmMessage, pushQueue.getPushToken(), 3);
            }
            catch (Exception e) {
                log.error("exception in realtime send gcm : {}", (Throwable)e);
            }
            resList.add(this.getGcmResult(result, pushQueue));
        }
        return resList;
    }

    @Override
    public void setServerId(String serverId) {
    }

    static {
        GCM_ERROR_CODE_MAP.put("NotRegistered", "2006");
        GCM_ERROR_CODE_MAP.put("QuotaExceeded", "2001");
        GCM_ERROR_CODE_MAP.put("DeviceQuotaExceeded", "2002");
        GCM_ERROR_CODE_MAP.put("MissingRegistration", "2003");
        GCM_ERROR_CODE_MAP.put("InvalidRegistration", "2004");
        GCM_ERROR_CODE_MAP.put("MismatchSenderId", "2005");
        GCM_ERROR_CODE_MAP.put("MessageTooBig", "2007");
        GCM_ERROR_CODE_MAP.put("MissingCollapseKey", "2008");
    }
}

