/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.batch.service.impl;

import com.google.android.gcm.server.Message;
import com.google.android.gcm.server.MulticastResult;
import com.google.android.gcm.server.Result;
import com.google.android.gcm.server.Sender;
import com.humuson.tms.batch.domain.App;
import com.humuson.tms.batch.service.GcmHttpService;
import com.humuson.tms.common.util.StringUtils;
import com.humuson.tms.mq.model.MgsPush;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.json.simple.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GcmHttpMqServiceImpl
implements GcmHttpService<MgsPush.Response.ResponsePayload, MgsPush.PushPayload> {
    private static final Logger log = LoggerFactory.getLogger(GcmHttpMqServiceImpl.class);
    ConcurrentHashMap<String, Sender> gcmSenderConcurrentMap = new ConcurrentHashMap();
    public static Map<String, String> GCM_ERROR_CODE_MAP = new ConcurrentHashMap<String, String>();
    String serverId;

    @Override
    public MgsPush.Response.ResponsePayload sendGcmMessage(MgsPush.PushPayload payLoad, String gcmApiKey) {
        Message gcmMessage = this.makeGcmMessage(payLoad);
        Result result = null;
        try {
            result = this.gcmSenderConcurrentMap.get(gcmApiKey).send(gcmMessage, payLoad.getToken(), 3);
        }
        catch (Exception e) {
            log.error("exception in realtime send gcm : {}", (Throwable)e);
        }
        return this.getGcmResult(result, payLoad);
    }

    public List<MgsPush.Response.ResponsePayload> sendGcmMulticastMessage(MgsPush.PushPayload[] rawUser, Message msg, String gcmApiKey) {
        Message message = msg == null ? this.makeGcmMessage(rawUser[0]) : msg;
        MulticastResult multicastResult = null;
        MgsPush.Response.ResponsePayload.Builder tempPayloadBuilder = MgsPush.Response.ResponsePayload.newBuilder();
        ArrayList<String> partialDevices = new ArrayList<String>();
        for (MgsPush.PushPayload payLoad : rawUser) {
            if (StringUtils.isNull((String)payLoad.getToken())) {
                log.error("GCM empty token is {}", (Object)payLoad.getId());
                continue;
            }
            partialDevices.add(payLoad.getToken());
        }
        try {
            multicastResult = this.gcmSenderConcurrentMap.get(gcmApiKey).send(message, partialDevices, 1);
        }
        catch (Exception e) {
            log.error("multicate send gcm error", (Throwable)e);
            multicastResult = null;
        }
        ArrayList<MgsPush.Response.ResponsePayload> resultList = new ArrayList<MgsPush.Response.ResponsePayload>();
        if (multicastResult != null) {
            List<Result> results = multicastResult.getResults();
            int size = results.size();
            for (int i = 0; i < size; ++i) {
                resultList.add(this.getGcmResult(results.get(i), rawUser[i]));
            }
        } else {
            StringBuilder sb = new StringBuilder();
            for (MgsPush.PushPayload user : rawUser) {
                tempPayloadBuilder.clear();
                tempPayloadBuilder.setId(user.getId());
                tempPayloadBuilder.setReturnCode(MgsPush.Response.ReturnCode.UNKNOWN_FAIL);
                resultList.add(tempPayloadBuilder.build());
            }
        }
        return resultList;
    }

    @Override
    public MgsPush.Response.ResponsePayload getGcmResult(Result result, MgsPush.PushPayload payLoad) {
        MgsPush.Response.ResponsePayload.Builder responsePayloadBuilder = MgsPush.Response.ResponsePayload.newBuilder();
        String changedToken = null;
        responsePayloadBuilder.setId(payLoad.getId());
        responsePayloadBuilder.setServerId(this.serverId);
        responsePayloadBuilder.setReturnCode(MgsPush.Response.ReturnCode.SUCCESSFUL);
        if (result == null) {
            responsePayloadBuilder.clear();
            responsePayloadBuilder.setId(payLoad.getId());
            responsePayloadBuilder.setServerId(this.serverId);
            responsePayloadBuilder.setReturnCode(MgsPush.Response.ReturnCode.ERROR_UNAVAILABLE);
            return responsePayloadBuilder.build();
        }
        String messageId = result.getMessageId();
        if (messageId != null) {
            if (result.getCanonicalRegistrationId() != null) {
                changedToken = result.getCanonicalRegistrationId();
                responsePayloadBuilder.clear();
                responsePayloadBuilder.setId(payLoad.getId());
                responsePayloadBuilder.setServerId(this.serverId);
                responsePayloadBuilder.setReturnCode(MgsPush.Response.ReturnCode.CHANGED_SUCCESSFUL);
            }
        } else {
            String error = result.getErrorCodeName();
            if (GCM_ERROR_CODE_MAP.containsKey(result.getErrorCodeName())) {
                String resultCode = GCM_ERROR_CODE_MAP.get(error);
                responsePayloadBuilder.clear();
                responsePayloadBuilder.setId(payLoad.getId());
                responsePayloadBuilder.setServerId(this.serverId);
                responsePayloadBuilder.setReturnCode(MgsPush.Response.ReturnCode.valueOf((int)Integer.parseInt(resultCode)));
            } else {
                responsePayloadBuilder.clear();
                responsePayloadBuilder.setId(payLoad.getId());
                responsePayloadBuilder.setServerId(this.serverId);
                responsePayloadBuilder.setReturnCode(MgsPush.Response.ReturnCode.ERROR_UNAVAILABLE);
                log.error("gcm response is unavaliable : {}", (Object)result.toString());
            }
        }
        return responsePayloadBuilder.build();
    }

    @Override
    public void init(App appInfo) {
        if (this.gcmSenderConcurrentMap.get(appInfo.getGcmApiKey()) == null) {
            Sender sender = new Sender(appInfo.getGcmApiKey());
            this.gcmSenderConcurrentMap.put(appInfo.getGcmApiKey(), sender);
        }
    }

    @Override
    public Message makeGcmMessage(MgsPush.PushPayload payload) {
        MgsPush.GcmMessage gcmMessage = payload.getGcmMessage();
        Message.Builder builder = new Message.Builder();
        builder.addData("notiMsg", gcmMessage.getPushNotiMsg());
        builder.addData("notiTitle", StringUtils.validString((String)gcmMessage.getPushNotiTitle()));
        String pushImage = gcmMessage.getPushNotiImg();
        if (pushImage != null && !pushImage.startsWith("http://") && "http://".length() >= pushImage.length()) {
            pushImage = "";
        }
        builder.addData("notiImg", pushImage == null ? "" : pushImage);
        builder.addData("message", gcmMessage.getPushRichContent());
        builder.addData("t", gcmMessage.getMsgType());
        builder.addData("i", String.valueOf(gcmMessage.getMsgId()));
        JSONObject json = new JSONObject();
        builder.addData("d", gcmMessage.getPushData());
        builder.delayWhileIdle(false);
        return builder.build();
    }

    @Override
    public List<MgsPush.Response.ResponsePayload> sendGcmOne2OneList(Collection<MgsPush.PushPayload> payloadList, String gcmApiKey) {
        ArrayList<MgsPush.Response.ResponsePayload> resList = new ArrayList<MgsPush.Response.ResponsePayload>();
        Sender sender = this.gcmSenderConcurrentMap.get(gcmApiKey);
        for (MgsPush.PushPayload payload : payloadList) {
            Message gcmMessage = this.makeGcmMessage(payload);
            Result result = null;
            try {
                result = sender.send(gcmMessage, payload.getToken(), 3);
                if (log.isDebugEnabled()) {
                    log.debug("result : {}, payload:{}", (Object)result.getMessageId(), (Object)payload.getToken());
                }
            }
            catch (Exception e) {
                log.error("exception in realtime send gcm : {}", (Throwable)e);
            }
            resList.add(this.getGcmResult(result, payload));
        }
        return resList;
    }

    @Override
    public void setServerId(String serverId) {
        this.serverId = serverId;
    }

    static {
        GCM_ERROR_CODE_MAP.put("NotRegistered", "2006");
        GCM_ERROR_CODE_MAP.put("QuotaExceeded", "2001");
        GCM_ERROR_CODE_MAP.put("DeviceQuotaExceeded", "2002");
        GCM_ERROR_CODE_MAP.put("MissingRegistration", "2003");
        GCM_ERROR_CODE_MAP.put("InvalidRegistration", "2004");
        GCM_ERROR_CODE_MAP.put("MismatchSenderId", "2005");
        GCM_ERROR_CODE_MAP.put("MessageTooBig", "2007");
        GCM_ERROR_CODE_MAP.put("MissingCollapseKey", "2008");
    }
}

