/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.batch.service.impl;

import com.google.android.gcm.ccs.server.CcsConnectionManager;
import com.google.android.gcm.ccs.server.GcmPacketExtension;
import com.google.android.gcm.ccs.server.XMPPGCMConnection;
import com.humuson.tms.batch.domain.PushMessage;
import com.humuson.tms.batch.domain.PushQueue;
import com.humuson.tms.common.model.mq.PushSendType;
import com.humuson.tms.common.util.PushCcsMessageIdUtil;
import com.humuson.tms.common.util.StringUtils;
import com.humuson.tms.mq.model.MgsPush;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.packet.Stanza;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class GcmCcsService {
    private static final Logger log = LoggerFactory.getLogger(GcmCcsService.class);
    @Autowired
    private CcsConnectionManager ccsConnectionManager;
    private long projectId;
    private String strProjectId;
    private String apiKey;
    private int hitCount;
    Random rnd = new Random();
    @Value(value="#{config['xmpp.sending.size']}")
    private int resetPeriod;
    @Value(value="#{config['xmpp.connection.size']}")
    private int maxConnection;
    @Value(value="#{config['xmpp.upstream.use.flag']}")
    private boolean upstreamUseFlag;
    private XMPPGCMConnection connection;
    protected volatile boolean connectionDraining = false;

    public GcmCcsService() {
        log.debug("GcmCcsService Create!!");
    }

    public void init(long projectId, String apiKey) {
        this.strProjectId = String.valueOf(projectId);
        this.setProjectId(projectId);
        this.setApiKey(apiKey);
        this.connection = this.ccsConnectionManager.getConnection(projectId, apiKey);
    }

    public void reset() {
        this.connection = this.ccsConnectionManager.getConnection(this.getProjectId(), this.getApiKey());
    }

    public synchronized void checkHitCnt() {
        int cnt = this.getHitCount();
        if (cnt >= this.resetPeriod) {
            this.setHitCount(0);
            this.reset();
            log.debug("CCS Connection Reset!!");
        } else {
            this.setHitCount(++cnt);
        }
    }

    public boolean sendDownstreamMessage(String jsonRequest) throws SmackException.NotConnectedException {
        if (!this.connection.isDrainning() && this.connection.isConnected()) {
            this.send(jsonRequest);
            return true;
        }
        for (int i = 0; i < this.maxConnection; ++i) {
            this.reset();
            if (!this.connection.isDrainning() && this.connection.isConnected()) break;
        }
        this.send(jsonRequest);
        log.info("Dropping downstream message since the connection is draining");
        return false;
    }

    protected void send(String jsonRequest) throws SmackException.NotConnectedException {
        this.checkHitCnt();
        Stanza request = new GcmPacketExtension(jsonRequest).toPacket();
        request.setTo(this.strProjectId);
        this.connection.sendStanza(request);
    }

    protected void sendTest(String jsonRequest) throws SmackException.NotConnectedException {
        Stanza request = new GcmPacketExtension(jsonRequest).toPacket();
        this.connection.sendStanza(request);
    }

    protected void handleUpstreamMessage(Map<String, Object> jsonObject) {
    }

    protected static String createJsonAck(String to, String messageId) {
        HashMap<String, String> message = new HashMap<String, String>();
        message.put("message_type", "ack");
        message.put("to", to);
        message.put("message_id", messageId);
        return JSONValue.toJSONString(message);
    }

    public static void main(String[] args) throws Exception {
        long senderId = 997255892867L;
        String password = "AIzaSyBROhTcnB_9eSYqAjGwCc1s82T3UfngCZ8";
        CcsConnectionManager ccsConnectionManager = new CcsConnectionManager();
        GcmCcsService ccsClient = new GcmCcsService();
        String toRegId = "APA91bFiCylyZWeFV1yQmSL2e6F5PCJUf7BkUuaTvN4dRkcPZ5q38I3eneXzvoBrnrh3q-KaUMKe2hDsB_jUKO7h6aqmBNSXLlp5yK7pvrpH3z11ayt1PLc";
        String messageId = "1602181428";
        HashMap<String, String> payload = new HashMap<String, String>();
        payload.put("notiMsg", "test");
        payload.put("notiTitle", "Test Message");
        payload.put("notiImg", "");
        payload.put("message", "");
        payload.put("t", "T");
        payload.put("i", messageId);
        JSONObject json = new JSONObject();
        json.put((Object)"l", (Object)"");
        payload.put("d", json.toString());
        payload.put("sound", "default");
        Object collapseKey = null;
        int timeToLive = -1;
        HashMap<String, Object> message = new HashMap<String, Object>();
        message.put("to", toRegId);
        if (collapseKey != null) {
            message.put("collapse_key", collapseKey);
        }
        if (timeToLive >= 0) {
            message.put("time_to_live", timeToLive);
        }
        message.put("message_id", messageId);
        message.put("data", payload);
        try {
            ccsClient.sendTest(JSONValue.toJSONString(message));
            Thread.sleep(60000L);
            System.out.println("TEST END");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public long getProjectId() {
        return this.projectId;
    }

    public void setProjectId(long projectId) {
        this.projectId = projectId;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public int getHitCount() {
        return this.hitCount;
    }

    public void setHitCount(int hitCount) {
        this.hitCount = hitCount;
    }

    public String makeCcsMessage(PushQueue pushQueue, PushMessage pushMessage, int appGrpId) {
        String toRegId = pushQueue.getPushToken();
        long pushId = pushQueue.getPushId();
        String chunkId = pushQueue.getChunkId();
        HashMap<String, String> payload = new HashMap<String, String>();
        payload.put("notiMsg", pushMessage.getPushMsg());
        payload.put("notiTitle", pushMessage.getPushTitle() == null ? "" : pushMessage.getPushTitle());
        String pushImage = pushMessage.getPushImg();
        if (pushImage != null && !pushImage.startsWith("http://") && "http://".length() >= pushImage.length()) {
            pushImage = "";
        }
        payload.put("notiImg", pushImage);
        payload.put("message", pushMessage.getPopupContent());
        payload.put("t", pushMessage.getMsgType());
        payload.put("i", String.valueOf(pushMessage.getMsgUid()));
        JSONObject json = new JSONObject();
        String key = pushMessage.getPushKey();
        String value = pushMessage.getPushValue();
        if (!StringUtils.isEmpty((CharSequence)key)) {
            json.put((Object)key, (Object)(value == null ? "" : value));
        }
        payload.put("d", json.toString());
        Object collapseKey = null;
        int timeToLive = -1;
        HashMap<String, Object> message = new HashMap<String, Object>();
        message.put("to", toRegId);
        if (collapseKey != null) {
            message.put("collapse_key", collapseKey);
        }
        if (timeToLive >= 0) {
            message.put("time_to_live", timeToLive);
        }
        message.put("delay_while_idle", false);
        long deviceId = pushQueue.getDeviceId();
        message.put("message_id", PushCcsMessageIdUtil.makeCcsMessageId((long)pushId, (long)deviceId, (String)pushQueue.getReqUid(), (String)pushQueue.getCustId(), (int)appGrpId, (String)pushQueue.getServerId(), (PushSendType)PushSendType.TB));
        message.put("data", payload);
        if (this.upstreamUseFlag) {
            message.put("delivery_receipt_requested", true);
        } else {
            message.put("delivery_receipt_requested", false);
        }
        return JSONValue.toJSONString(message);
    }

    public String makeCcsMessage(PushQueue pushQueue, PushMessage pushMessage, int appGrpId, PushSendType pushSendType) {
        String toRegId = pushQueue.getPushToken();
        long pushId = pushQueue.getPushId();
        String chunkId = pushQueue.getChunkId();
        HashMap<String, String> payload = new HashMap<String, String>();
        payload.put("notiMsg", pushMessage.getPushMsg());
        payload.put("notiTitle", pushMessage.getPushTitle() == null ? "" : pushMessage.getPushTitle());
        String pushImage = pushMessage.getPushImg();
        if (pushImage != null && !pushImage.startsWith("http://") && "http://".length() >= pushImage.length()) {
            pushImage = "";
        }
        payload.put("notiImg", pushImage);
        payload.put("message", pushMessage.getPopupContent());
        payload.put("t", pushMessage.getMsgType());
        payload.put("i", String.valueOf(pushMessage.getMsgUid()));
        JSONObject json = new JSONObject();
        String key = pushMessage.getPushKey();
        String value = pushMessage.getPushValue();
        if (!StringUtils.isEmpty((CharSequence)key)) {
            json.put((Object)key, (Object)(value == null ? "" : value));
        }
        payload.put("d", json.toString());
        Object collapseKey = null;
        int timeToLive = -1;
        HashMap<String, Object> message = new HashMap<String, Object>();
        message.put("to", toRegId);
        if (collapseKey != null) {
            message.put("collapse_key", collapseKey);
        }
        if (timeToLive >= 0) {
            message.put("time_to_live", timeToLive);
        }
        message.put("delay_while_idle", false);
        long deviceId = pushQueue.getDeviceId();
        if (PushSendType.TB.equals((Object)pushSendType)) {
            message.put("message_id", PushCcsMessageIdUtil.makeCcsMessageId((long)pushId, (long)deviceId, (String)pushQueue.getReqUid(), (String)pushQueue.getCustId(), (int)appGrpId, (String)pushQueue.getServerId(), (PushSendType)pushSendType));
        } else if (PushSendType.MQ.equals((Object)pushSendType)) {
            StringBuffer sb = new StringBuffer();
            sb.append("PUSH_ID_VALUE").append("&&").append(String.valueOf(deviceId)).append("&&").append(pushQueue.getReqUid()).append("&&").append(pushQueue.getCustId());
            message.put("message_id", PushCcsMessageIdUtil.makeCcsMessageId((String)sb.toString(), (int)appGrpId, (String)pushQueue.getServerId(), (PushSendType)pushSendType));
        }
        message.put("data", payload);
        if (this.upstreamUseFlag) {
            message.put("delivery_receipt_requested", true);
        } else {
            message.put("delivery_receipt_requested", false);
        }
        return JSONValue.toJSONString(message);
    }

    public String makeCcsMessage(MgsPush.PushPayload pushPayload, int appGrpId, String serverId) {
        String toRegId = pushPayload.getToken();
        HashMap<String, String> payload = new HashMap<String, String>();
        payload.put("notiMsg", pushPayload.getGcmMessage().getPushNotiMsg());
        payload.put("notiTitle", pushPayload.getGcmMessage().getPushNotiTitle());
        String pushImage = pushPayload.getGcmMessage().getPushNotiImg();
        if (pushImage != null && !pushImage.startsWith("http://") && "http://".length() >= pushImage.length()) {
            pushImage = "";
        }
        payload.put("notiImg", pushImage);
        payload.put("message", pushPayload.getGcmMessage().getPushRichContent());
        payload.put("t", pushPayload.getGcmMessage().getMsgType());
        payload.put("i", String.valueOf(pushPayload.getGcmMessage().getMsgId()));
        JSONObject json = new JSONObject();
        payload.put("d", pushPayload.getGcmMessage().getPushData());
        Object collapseKey = null;
        int timeToLive = -1;
        HashMap<String, Object> message = new HashMap<String, Object>();
        message.put("to", toRegId);
        if (collapseKey != null) {
            message.put("collapse_key", collapseKey);
        }
        if (timeToLive >= 0) {
            message.put("time_to_live", timeToLive);
        }
        message.put("delay_while_idle", false);
        message.put("message_id", PushCcsMessageIdUtil.makeCcsMessageId((String)pushPayload.getId(), (int)appGrpId, (String)serverId, (PushSendType)PushSendType.MQ));
        message.put("data", payload);
        if (this.upstreamUseFlag) {
            message.put("delivery_receipt_requested", true);
        } else {
            message.put("delivery_receipt_requested", false);
        }
        return JSONValue.toJSONString(message);
    }
}

