/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.batch.service.impl;

import com.humuson.tms.batch.domain.FatigueFilterSchedule;
import com.humuson.tms.batch.domain.Schedule;
import com.humuson.tms.batch.service.ScheduleStatusUpdateService;
import com.humuson.tms.constrants.CommonType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.namedparam.BeanPropertySqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class FatigueFilterScheduleStatusUpdateService
implements ScheduleStatusUpdateService {
    private static final Logger log = LoggerFactory.getLogger(FatigueFilterScheduleStatusUpdateService.class);
    private static final String UNDER_BAR = "_";
    private String updateSchdJobStatusSql;
    private String updateCampSchdJobStatusSql;
    private String updateAutoSchdJobStatusSql;
    @Autowired
    private NamedParameterJdbcTemplate namedParameterJdbcTemplate;

    @Override
    public int updateSchdlStatus(Schedule schedule) {
        log.debug("updateSchdlStatus()... Schedule: {}", (Object)schedule);
        if (schedule instanceof FatigueFilterSchedule) {
            FatigueFilterSchedule target = (FatigueFilterSchedule)schedule;
            String sendType = target.getSendType();
            if (CommonType.MASS.getCode().equals(sendType)) {
                this.updateSchdJobStatusSql = this.updateCampSchdJobStatusSql;
            } else if (CommonType.AUTO.getCode().equals(sendType)) {
                String[] postId = target.getPostId().split(UNDER_BAR);
                if (postId.length < 2) {
                    return -1;
                }
                target.setWorkday(postId[0]);
                String seqno = postId[1];
                try {
                    target.setSeqno(Integer.parseInt(seqno));
                }
                catch (Exception e) {
                    log.error("updateSchdlStatus()... Wrong SEQNO: [ " + seqno + " ] !", (Throwable)e);
                    return -1;
                }
                this.updateSchdJobStatusSql = this.updateAutoSchdJobStatusSql;
            } else {
                log.error("updateSchdlStatus()... Wrong SEND_TYPE!. SendType: {}", (Object)sendType);
                return -1;
            }
            log.debug("updateSchdlStatus()... Target: {}", (Object)target);
            return this.namedParameterJdbcTemplate.update(this.updateSchdJobStatusSql, (SqlParameterSource)new BeanPropertySqlParameterSource((Object)target));
        }
        return -1;
    }

    public void setUpdateCampSchdJobStatusSql(String updateCampSchdJobStatusSql) {
        this.updateCampSchdJobStatusSql = updateCampSchdJobStatusSql;
    }

    public void setUpdateAutoSchdJobStatusSql(String updateAutoSchdJobStatusSql) {
        this.updateAutoSchdJobStatusSql = updateAutoSchdJobStatusSql;
    }
}

