/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.batch.service.impl;

import com.humuson.tms.batch.domain.FatigueFilterSchedule;
import com.humuson.tms.batch.service.ScheduleService;
import com.humuson.tms.constrants.ChannelType;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public class FatigueFilterScheduleService
implements ScheduleService<FatigueFilterSchedule> {
    private static final Logger log = LoggerFactory.getLogger(FatigueFilterScheduleService.class);
    ConcurrentHashMap<String, Boolean> runningScheduleMap = new ConcurrentHashMap();
    private String selectSchedule;
    private String updateSchedule;
    @Autowired
    private JdbcTemplate jdbcTemplate;

    @Override
    public boolean isRunning(String key) {
        Boolean isRun = this.runningScheduleMap.get(key);
        if (isRun == null) {
            return false;
        }
        return isRun;
    }

    @Override
    public void setRunning(String id, boolean isRun) {
        this.runningScheduleMap.put(id, isRun);
    }

    @Override
    public List<FatigueFilterSchedule> getScheduleList(Object[] params) {
        List list = this.jdbcTemplate.query(this.selectSchedule, (RowMapper)new RowMapper<FatigueFilterSchedule>(){

            public FatigueFilterSchedule mapRow(ResultSet rs, int rowNum) throws SQLException {
                FatigueFilterSchedule schedule = new FatigueFilterSchedule();
                schedule.setSendType(rs.getString("SEND_TYPE"));
                schedule.setPostId(rs.getString("POST_ID"));
                schedule.setServerId(rs.getString("SERVER_ID"));
                schedule.setSiteId(rs.getInt("SITE_ID"));
                schedule.setWorkday(rs.getString("WORKDAY"));
                schedule.setChannelType(ChannelType.valueOfCode((String)rs.getString("CHN_TYPE")));
                schedule.setListTable(rs.getString("LIST_TABLE"));
                return schedule;
            }
        }, params);
        log.debug("getScheduleList()...  Result List: {}", (Object)list);
        return list;
    }

    @Override
    public int updateScheduleStatus(String key, String status) {
        return 0;
    }

    @Override
    public List<FatigueFilterSchedule> getScheduleList() {
        return this.getScheduleList(new Object[0]);
    }

    @Override
    public boolean isCanceled(String key) {
        return false;
    }

    public void setSelectSchedule(String selectSchedule) {
        this.selectSchedule = selectSchedule;
    }

    public void setUpdateSchedule(String updateSchedule) {
        this.updateSchedule = updateSchedule;
    }
}

