/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.batch.service.impl;

import com.humuson.tms.batch.domain.DirectQueue;
import com.humuson.tms.batch.domain.DirectQueueResult;
import com.humuson.tms.batch.service.DirectPushResultService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSourceUtils;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public class DirectPushResultServiceImpl
implements DirectPushResultService {
    private static final Logger log = LoggerFactory.getLogger(DirectPushResultServiceImpl.class);
    @Autowired
    protected NamedParameterJdbcTemplate namedParameterJdbcTemplate;
    @Autowired
    protected JdbcTemplate jdbcTemplate;
    private String updateDirectQueue;
    private String insertDirectQueueResult;

    @Override
    public int updateDirectQueue(DirectQueue pushQueue) {
        int result = this.namedParameterJdbcTemplate.update(this.updateDirectQueue, pushQueue.toMap());
        return result;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Throwable.class})
    public int[] batchUpdateDirectQueue(List<DirectQueue> list) {
        SqlParameterSource[] params = SqlParameterSourceUtils.createBatch((Object[])list.toArray());
        int[] result = null;
        try {
            result = this.namedParameterJdbcTemplate.batchUpdate(this.updateDirectQueue, params);
        }
        catch (Exception e) {
            log.error("batch update failed", (Throwable)e);
            result = null;
        }
        return result;
    }

    @Override
    public int insertDirectQueueResult(DirectQueueResult directQueueResult) {
        int result = this.namedParameterJdbcTemplate.update(this.insertDirectQueueResult, directQueueResult.toMap());
        return result;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Throwable.class})
    public int[] batchInsertDirectQueueResult(List<DirectQueueResult> list) {
        SqlParameterSource[] params = SqlParameterSourceUtils.createBatch((Object[])list.toArray());
        int[] result = null;
        try {
            result = this.namedParameterJdbcTemplate.batchUpdate(this.insertDirectQueueResult, params);
        }
        catch (Exception e) {
            log.error("batch update failed", (Throwable)e);
            result = null;
        }
        return result;
    }

    public void setUpdateDirectQueue(String updateDirectQueue) {
        this.updateDirectQueue = updateDirectQueue;
    }

    public void setInsertDirectQueueResult(String insertDirectQueueResult) {
        this.insertDirectQueueResult = insertDirectQueueResult;
    }
}

