/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.batch.service.impl;

import com.humuson.tms.batch.service.ComposeTargetSqlService;
import com.humuson.tms.common.model.target.TargetInfo;
import com.humuson.tms.constrants.ChannelType;
import com.humuson.tms.constrants.TargetType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class ComposeTargetSqlServiceImpl
implements ComposeTargetSqlService {
    private static final Logger log = LoggerFactory.getLogger(ComposeTargetSqlServiceImpl.class);
    protected static final int NOT_EXIST = 0;
    protected static final int EXIST = 1;
    protected static final String VALUE = "VALUE";
    protected static final String CLASS = "TARGET_CLASS";
    protected static final String USER = "USER";
    protected static final String OPERATOR = "OPERATOR";
    protected static final String COLUMN_NAME = "TARGET_COLUMN";
    protected static final String DEVICE = "DEVICE";
    protected static final String APP_VER = "APP_VER";
    protected static final String OS_VER = "OS_VER";
    protected static final String DEVICE_ANALY_ID = "DEVICE_ANALY_ID";
    protected static final String APP_VER_ANALY_ID = "APP_VER_ANALY_ID";
    protected static final String OS_VER_ANALY_ID = "OS_VER_ANALY_ID";
    protected static final String ALL_DEVICE = "A";
    protected static final String LOGOUT_DEVICE = "U";
    protected static final String LOGIN_DEVICE = "L";
    protected static final String ANDROID = "A";
    protected static final String IOS = "I";
    protected static final String EQUAL = "=";
    protected static final String IN = "IN";
    protected static final String USE = "Y";
    protected static final String IS_EMPTY = " = ''";
    protected static final String IS_NOT_EMPTY = " != ''";
    protected static final String IS_NULL = " IS NULL";
    protected static final String IS_NOT_NULL = " IS NOT NULL";
    private String selectTargetCondition;
    private String androidAppIdClause;
    private String iOSAppIdClause;
    private String userSessRawCond;
    private String siteUserMktEmailYn;
    private String siteUserMktPushYn;
    private String siteUserMktSmsYn;
    private String logoutSelectClause;
    private String logoutFromClause;
    private String logoutWhereClause;
    private String loginSelectClause;
    private String loginFromClause;
    private String loginWhereClause;
    private String loginSelectClauseForAmcTargeting;
    private String loginFromClauseForAmcTargeting;
    private String loginWhereClauseAppendForAmcTargeting;
    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Autowired
    NamedParameterJdbcTemplate namedParameterJdbcTemplate;
    @Value(value="#{dbConfig['tms.jdbc.type']}")
    protected String dbType;

    @Override
    public int getCondTargetCount(String msgId, String channelType, TargetInfo targetInfo, ExecutionContext executionContext) {
        boolean isMkt;
        String sessionStartDate = "";
        String sessionEndDate = "";
        if (targetInfo.getTargetCondInfo() != null) {
            sessionStartDate = targetInfo.getTargetCondInfo().getSessionStartDate();
            sessionEndDate = targetInfo.getTargetCondInfo().getSessionEndDate();
        }
        String targetUserType = targetInfo.getUseLogin();
        String useCondition = targetInfo.getUseCondition();
        String platformType = targetInfo.getUsePlatform();
        StringBuilder whereClauseBuilder = new StringBuilder();
        StringBuilder fromClauseBuilder = new StringBuilder();
        StringBuilder selectClauseBuilder = new StringBuilder();
        StringBuilder userSessionCondBuf = new StringBuilder();
        boolean isLoginTargeting = false;
        boolean bl = isMkt = USE.equalsIgnoreCase(targetInfo.getMktYn());
        if (log.isDebugEnabled()) {
            log.debug("useCondition:{}, sessionStartDate:{}, sessionEndDate:{}", new Object[]{useCondition, sessionStartDate, sessionEndDate});
        }
        MapSqlParameterSource parameterSource = new MapSqlParameterSource();
        if (TargetType.AMC.getCode().equals(targetInfo.getTargetType())) {
            selectClauseBuilder.append(this.loginSelectClauseForAmcTargeting);
            fromClauseBuilder.append(this.loginFromClauseForAmcTargeting);
            whereClauseBuilder.append(this.loginWhereClauseAppendForAmcTargeting);
        } else if (ChannelType.PUSH.getCode().equals(channelType) || ChannelType.PUSH.getCode().equals(targetInfo.getFirstChannelType())) {
            String step1 = null;
            String step2 = null;
            int androidAppId = executionContext.getInt("android.id", -1);
            int iosAppId = executionContext.getInt("ios.id", -1);
            if (targetUserType.equals("A")) {
                step1 = executionContext.getString("taget.all.device.step1", "unpass");
                step2 = executionContext.getString("taget.all.device.step2", "unpass");
                executionContext.put("taget.user.type", (Object)"A");
            }
            if (targetUserType.equals(LOGOUT_DEVICE) || targetUserType.equals("A") && "unpass".equals(step1)) {
                selectClauseBuilder.append(this.logoutSelectClause);
                fromClauseBuilder.append(this.logoutFromClause);
                whereClauseBuilder.append(this.logoutWhereClause);
            } else {
                selectClauseBuilder.append(this.loginSelectClause);
                fromClauseBuilder.append(this.loginFromClause);
                whereClauseBuilder.append(this.loginWhereClause);
                isLoginTargeting = true;
            }
            if ("A".equals(platformType)) {
                whereClauseBuilder.append(this.androidAppIdClause);
            } else if (IOS.equals(platformType)) {
                whereClauseBuilder.append(this.iOSAppIdClause);
            }
            if (USE.equals(useCondition)) {
                if (!"".equals(sessionStartDate) && !"".equals(sessionEndDate)) {
                    userSessionCondBuf.append(this.userSessRawCond);
                }
                List targetConditionList = this.jdbcTemplate.queryForList(this.selectTargetCondition, new Object[]{androidAppId, iosAppId, msgId});
                String condClass = null;
                String userCondKey = null;
                String userCondValue = null;
                Object appendix = null;
                ArrayList deviceCond = new ArrayList();
                ArrayList osVerCond = new ArrayList();
                ArrayList appVerCond = new ArrayList();
                HashMap condListMap = new HashMap();
                condListMap.put(DEVICE, deviceCond);
                condListMap.put(APP_VER, appVerCond);
                condListMap.put(OS_VER, osVerCond);
                for (Map targetConditionMap : targetConditionList) {
                    if (log.isDebugEnabled()) {
                        log.debug("targetConditionMap :[{}]", (Object)targetConditionMap.toString());
                    }
                    condClass = targetConditionMap.get(CLASS).toString();
                    userCondKey = targetConditionMap.get(COLUMN_NAME).toString().toLowerCase();
                    userCondValue = targetConditionMap.get(VALUE).toString();
                    if (!USER.equals(condClass)) {
                        List cond = (List)condListMap.get(condClass);
                        cond.add(userCondValue);
                        continue;
                    }
                    userSessionCondBuf.append("AND ");
                    userSessionCondBuf.append(userCondKey.toLowerCase());
                    userSessionCondBuf.append(" ").append(targetConditionMap.get(OPERATOR)).append(" ");
                    userSessionCondBuf.append(":" + userCondKey);
                    executionContext.put(userCondKey, (Object)targetConditionMap.get(VALUE).toString());
                    parameterSource.addValue(userCondKey, targetConditionMap.get(VALUE));
                }
                for (String s : condListMap.keySet()) {
                    int i;
                    List condDetailList;
                    if (DEVICE.equals(s)) {
                        condDetailList = (List)condListMap.get(s);
                        if (condDetailList.size() <= 0) continue;
                        userSessionCondBuf.append(" AND ");
                        userSessionCondBuf.append(" ( ");
                        for (i = 0; i < condDetailList.size(); ++i) {
                            userSessionCondBuf.append(DEVICE_ANALY_ID).append(EQUAL).append((String)condDetailList.get(i));
                            if (i == condDetailList.size() - 1) continue;
                            userSessionCondBuf.append(" OR ");
                        }
                        userSessionCondBuf.append(" ) ");
                        continue;
                    }
                    if (APP_VER.equals(s)) {
                        condDetailList = (List)condListMap.get(s);
                        if (condDetailList.size() <= 0) continue;
                        userSessionCondBuf.append(" AND ");
                        userSessionCondBuf.append(" ( ");
                        for (i = 0; i < condDetailList.size(); ++i) {
                            userSessionCondBuf.append(APP_VER_ANALY_ID).append(EQUAL).append((String)condDetailList.get(i));
                            if (i == condDetailList.size() - 1) continue;
                            userSessionCondBuf.append(" OR ");
                        }
                        userSessionCondBuf.append(" ) ");
                        continue;
                    }
                    if (!OS_VER.equals(s) || (condDetailList = (List)condListMap.get(s)).size() <= 0) continue;
                    userSessionCondBuf.append(" AND ");
                    userSessionCondBuf.append(" ( ");
                    for (i = 0; i < condDetailList.size(); ++i) {
                        userSessionCondBuf.append(OS_VER_ANALY_ID).append(EQUAL).append((String)condDetailList.get(i));
                        if (i == condDetailList.size() - 1) continue;
                        userSessionCondBuf.append(" OR ");
                    }
                    userSessionCondBuf.append(" ) ");
                }
            }
            if (userSessionCondBuf.length() > 0) {
                if ("mysql".equalsIgnoreCase(this.dbType) || "mariadb".equalsIgnoreCase(this.dbType)) {
                    userSessionCondBuf.append(" LIMIT 1 ");
                }
                userSessionCondBuf.append(")");
                whereClauseBuilder.append(userSessionCondBuf.toString());
            }
        }
        String select = selectClauseBuilder.toString();
        String where = whereClauseBuilder.toString();
        executionContext.put("s.key", (Object)"DEVICE_ID");
        if ("ORACLE".equalsIgnoreCase(this.dbType)) {
            if (USE.equals(useCondition) && isLoginTargeting) {
                select = select.replace("/*REPLACE_HINT*/", "/*+  LEADING(ADL AUL SUL) USE_NL(SUL ADL AUL) INDEX(ADL IDX_APP_DEVICE_03) INDEX(SUL PK_SITE_USER_LIST) INDEX(AUL IDX_APP_USER_LIST_02)   */");
                where = where.replace("/*REPLACE_SESS_RAW_HINT*/", "/*+ UNNEST NL_SJ INDEX(USR IDX_USER_SESS_RAW_01)*/");
            } else if (USE.equals(useCondition)) {
                select = select.replace("/*REPLACE_HINT*/", "/*+  INDEX(ADL IDX_APP_DEVICE_03) LEADING(ADL) */");
                where = where.replace("/*REPLACE_SESS_RAW_HINT*/", "/*+ UNNEST NL_SJ INDEX(USR IDX_USER_SESS_RAW_01)*/");
            } else {
                select = isLoginTargeting ? select.replace("/*REPLACE_HINT*/", "/*+  LEADING(ADL AUL SUL) USE_NL(SUL ADL AUL) INDEX(ADL IDX_APP_DEVICE_03) INDEX(SUL PK_SITE_USER_LIST) INDEX(AUL IDX_APP_USER_LIST_02)   */") : select.replace("/*REPLACE_HINT*/", "/*+  INDEX(ADL IDX_APP_DEVICE_03) LEADING(ADL) */");
            }
        }
        executionContext.put("s.clause", (Object)select);
        executionContext.put("f.clause", (Object)fromClauseBuilder.toString());
        executionContext.put("w.clause", (Object)where);
        parameterSource.addValue("siteId", (Object)targetInfo.getSiteId());
        parameterSource.addValue("appGrpId", (Object)targetInfo.getTargetCondInfo().getAppGrpId());
        parameterSource.addValue("androidAppId", (Object)targetInfo.getTargetCondInfo().getAndroidAppId());
        parameterSource.addValue("iosAppId", (Object)targetInfo.getTargetCondInfo().getIOsAppId());
        parameterSource.addValue("startDate", (Object)targetInfo.getTargetCondInfo().getSessionStartDate());
        parameterSource.addValue("endDate", (Object)targetInfo.getTargetCondInfo().getSessionEndDate());
        select = "1 AS cnt";
        where = whereClauseBuilder.toString();
        if ("ORACLE".equalsIgnoreCase(this.dbType)) {
            select = "/*REPLACE_HINT*/ 1 ";
            if (USE.equals(useCondition) && isLoginTargeting) {
                select = select.replace("/*REPLACE_HINT*/", "  /*+ USE_HASH (SUL ADL AUL)  INDEX_FFS(ADL IDX_APP_DEVICE_03) INDEX_FFS(SUL PK_SITE_USER_LIST) FULL(AUL)   */");
                where = where.replace("/*REPLACE_SESS_RAW_HINT*/", " /*+ UNNEST HASH_SJ FULL(USR) */");
            } else if (USE.equals(useCondition)) {
                select = select.replace("/*REPLACE_HINT*/", " /*+  INDEX(ADL IDX_APP_DEVICE_03) */");
                where = where.replace("/*REPLACE_SESS_RAW_HINT*/", " /*+ UNNEST HASH_SJ FULL(USR) */ ");
            } else {
                select = isLoginTargeting ? select.replace("/*REPLACE_HINT*/", " /*+ USE_HASH (SUL ADL AUL)  INDEX_FFS(ADL IDX_APP_DEVICE_03) INDEX_FFS(SUL PK_SITE_USER_LIST) FULL(AUL)  */") : select.replace("/*REPLACE_HINT*/", "/*+ INDEX(ADL IDX_APP_DEVICE_03)  */");
            }
        }
        if ("pass".equals(executionContext.getString("taget.all.device.step1", "unpass"))) {
            return 0;
        }
        log.info("------{}-------", (Object)("select count(*) from ( SELECT " + select + " FROM " + fromClauseBuilder.toString() + " WHERE " + where + ") tmp"));
        int targetCnt = (Integer)this.namedParameterJdbcTemplate.queryForObject("select count(*) from ( SELECT " + select + " FROM " + fromClauseBuilder.toString() + " WHERE " + where + ") tmp", (SqlParameterSource)parameterSource, Integer.class);
        if (log.isDebugEnabled()) {
            log.info("COND Target SQL:{}, count :{}", (Object)("select count(*) from ( SELECT " + select + " FROM " + fromClauseBuilder.toString() + " WHERE " + where + ") tmp"), (Object)targetCnt);
        }
        return targetCnt;
    }

    public void setSelectTargetCondition(String selectTargetCondition) {
        this.selectTargetCondition = selectTargetCondition;
    }

    public void setAndroidAppIdClause(String androidAppIdClause) {
        this.androidAppIdClause = androidAppIdClause;
    }

    public void setIOSAppIdClause(String iOSAppIdClause) {
        this.iOSAppIdClause = iOSAppIdClause;
    }

    public void setUserSessRawCond(String userSessRawCond) {
        this.userSessRawCond = userSessRawCond;
    }

    public void setSiteUserMktEmailYn(String siteUserMktEmailYn) {
        this.siteUserMktEmailYn = siteUserMktEmailYn;
    }

    public void setSiteUserMktPushYn(String siteUserMktPushYn) {
        this.siteUserMktPushYn = siteUserMktPushYn;
    }

    public void setSiteUserMktSmsYn(String siteUserMktSmsYn) {
        this.siteUserMktSmsYn = siteUserMktSmsYn;
    }

    public void setLogoutSelectClause(String logoutSelectClause) {
        this.logoutSelectClause = logoutSelectClause;
    }

    public void setLogoutFromClause(String logoutFromClause) {
        this.logoutFromClause = logoutFromClause;
    }

    public void setLogoutWhereClause(String logoutWhereClause) {
        this.logoutWhereClause = logoutWhereClause;
    }

    public void setLoginSelectClause(String loginSelectClause) {
        this.loginSelectClause = loginSelectClause;
    }

    public void setLoginFromClause(String loginFromClause) {
        this.loginFromClause = loginFromClause;
    }

    public void setLoginWhereClause(String loginWhereClause) {
        this.loginWhereClause = loginWhereClause;
    }

    public void setLoginSelectClauseForAmcTargeting(String loginSelectClauseForAmcTargeting) {
        this.loginSelectClauseForAmcTargeting = loginSelectClauseForAmcTargeting;
    }

    public void setLoginFromClauseForAmcTargeting(String loginFromClauseForAmcTargeting) {
        this.loginFromClauseForAmcTargeting = loginFromClauseForAmcTargeting;
    }

    public void setLoginWhereClauseAppendForAmcTargeting(String loginWhereClauseAppendForAmcTargeting) {
        this.loginWhereClauseAppendForAmcTargeting = loginWhereClauseAppendForAmcTargeting;
    }
}

