/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.batch.service.impl;

import com.humuson.tms.batch.domain.ApnsFeedback;
import com.humuson.tms.batch.service.AppUserRemover;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSourceUtils;

public class AppUserRemoverImpl
implements AppUserRemover {
    private static final Logger log = LoggerFactory.getLogger(AppUserRemoverImpl.class);
    @Autowired
    protected NamedParameterJdbcTemplate namedParameterJdbcTemplate;
    private String updateIosUnAcitveToken;
    private String updateAndroidNotRegisteredToken;
    private String insertDeleteDeviceList;

    @Override
    public int[] updateIosUnActiveToken(List<ApnsFeedback> list) {
        log.info("iOS Expired Tokens [size:{}]", (Object)list.size());
        SqlParameterSource[] params = SqlParameterSourceUtils.createBatch((Object[])list.toArray());
        return this.namedParameterJdbcTemplate.batchUpdate(this.updateIosUnAcitveToken, params);
    }

    @Override
    public int updateIosUnActiveToken(ApnsFeedback apnsFeedback) {
        return this.namedParameterJdbcTemplate.update(this.updateIosUnAcitveToken, apnsFeedback.toMap());
    }

    @Override
    public int updateAndroidNotRegisterToken(Integer deviceId) {
        return this.namedParameterJdbcTemplate.getJdbcOperations().update(this.updateAndroidNotRegisteredToken, new Object[]{deviceId});
    }

    @Override
    public int[] updateAndroidNotRegisterToken(List<Integer> list) {
        log.info("update Android NotRegistered Tokens [size:{}]", (Object)list.size());
        SqlParameterSource[] params = SqlParameterSourceUtils.createBatch((Object[])list.toArray());
        return this.namedParameterJdbcTemplate.batchUpdate(this.updateAndroidNotRegisteredToken, params);
    }

    @Override
    public int insertAppRemoveDeviceList(Integer deviceId) {
        return this.namedParameterJdbcTemplate.getJdbcOperations().update(this.insertDeleteDeviceList, new Object[]{deviceId});
    }

    @Override
    public int[] insertAppRemoveDeviceList(final List<Integer> list) {
        log.info("insert Android NotRegistered Tokens [size:{}]", (Object)list.size());
        return this.namedParameterJdbcTemplate.getJdbcOperations().batchUpdate(this.insertDeleteDeviceList, new BatchPreparedStatementSetter(){

            public void setValues(PreparedStatement ps, int i) throws SQLException {
                ps.setInt(1, (Integer)list.get(i));
            }

            public int getBatchSize() {
                return list.size();
            }
        });
    }

    public void setUpdateIosUnAcitveToken(String updateIosUnAcitveToken) {
        this.updateIosUnAcitveToken = updateIosUnAcitveToken;
    }

    public void setUpdateAndroidNotRegisteredToken(String updateAndroidNotRegisteredToken) {
        this.updateAndroidNotRegisteredToken = updateAndroidNotRegisteredToken;
    }

    public void setInsertDeleteDeviceList(String insertDeleteDeviceList) {
        this.insertDeleteDeviceList = insertDeleteDeviceList;
    }
}

