/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.batch.scheduler;

import com.humuson.tms.batch.domain.TargetSchedule;
import com.humuson.tms.batch.scheduler.AbstractScheduler;
import com.humuson.tms.common.util.StringUtils;
import com.humuson.tms.constrants.TargetStatus;
import java.util.List;
import java.util.Map;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.JobParameters;

public class TargetingScheduler
extends AbstractScheduler<TargetSchedule> {
    private static Logger logger = LoggerFactory.getLogger(TargetingScheduler.class);

    @Override
    protected void scheduleExecute(JobExecutionContext context) {
        JobDataMap jobDataMap = context.getMergedJobDataMap();
        List scheduleList = this.scheduleService.getScheduleList();
        if (logger.isDebugEnabled()) {
            logger.debug("Target ScheduleCount:{}", (Object)scheduleList.size());
        }
        long runTime = System.currentTimeMillis();
        for (TargetSchedule schedule : scheduleList) {
            if (this.scheduleService.isRunning(schedule.getMsgId()) || !jobDataMap.containsKey(schedule.getTargetType().toUpperCase())) continue;
            String jobName = jobDataMap.get(schedule.getTargetType().toUpperCase()).toString();
            jobDataMap.put("req.time", runTime);
            jobDataMap.put("send.list.table", StringUtils.getSendListTable((String)schedule.getPostId()));
            jobDataMap.put("chn.type", schedule.getChannelType().getCode());
            jobDataMap.put("post.id", schedule.getPostId());
            jobDataMap.put("msg.id", schedule.getMsgId());
            jobDataMap.put("target.type", schedule.getTargetType());
            jobDataMap.put("deduplication.yn", schedule.getDeduplicationYn());
            JobParameters jobParameters = this.getJobParametersFromJobMap((Map<String, Object>)jobDataMap);
            boolean isExist = this.jobRepository.isJobInstanceExists(jobName, jobParameters);
            if (isExist) continue;
            try {
                this.jobLauncher.run(this.jobLocator.getJob(jobName), jobParameters);
                this.scheduleService.setRunning(schedule.getMsgId(), true);
                this.scheduleService.updateScheduleStatus(schedule.getMsgId(), TargetStatus.RUNNING.getCode());
            }
            catch (Exception e) {
                logger.error("Could not execute job.", (Throwable)e);
                this.scheduleService.updateScheduleStatus(schedule.getMsgId(), TargetStatus.ERROR.getCode());
                this.scheduleService.setRunning(schedule.getMsgId(), false);
            }
        }
    }
}

