/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.batch.scheduler;

import com.humuson.tms.batch.domain.SmsUpdateSchedule;
import com.humuson.tms.batch.scheduler.AbstractScheduler;
import java.util.List;
import java.util.Map;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.JobParameters;

public class SmsUpdateScheduler
extends AbstractScheduler<SmsUpdateSchedule> {
    private static Logger logger = LoggerFactory.getLogger(SmsUpdateScheduler.class);

    @Override
    protected void scheduleExecute(JobExecutionContext context) {
        JobDataMap jobDataMap = context.getMergedJobDataMap();
        String jobName = (String)jobDataMap.get("jobName");
        List scheduleList = this.scheduleService.getScheduleList();
        if (logger.isDebugEnabled()) {
            logger.debug("Push Update ScheduleCount:{}", (Object)scheduleList.size());
        }
        long runTime = System.currentTimeMillis();
        for (SmsUpdateSchedule schedule : scheduleList) {
            if (schedule.getMinId() == schedule.getMaxId() && schedule.getMinId() == 0L) continue;
            jobDataMap.put("max.id", schedule.getMaxId());
            jobDataMap.put("min.id", schedule.getMinId());
            jobDataMap.put("req.time", runTime / 5000L);
            JobParameters jobParameters = this.getJobParametersFromJobMap((Map<String, Object>)jobDataMap);
            boolean isExist = this.jobRepository.isJobInstanceExists(jobName, jobParameters);
            if (isExist || this.scheduleService.isRunning(jobName)) continue;
            try {
                this.scheduleService.setRunning(jobName, true);
                this.jobLauncher.run(this.jobLocator.getJob(jobName), jobParameters);
            }
            catch (Exception e) {
                logger.error("Could not execute job.", (Throwable)e);
                this.scheduleService.setRunning(jobName, false);
            }
        }
    }
}

