/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.batch.scheduler;

import com.humuson.tms.batch.domain.PushSendSchedule;
import com.humuson.tms.batch.scheduler.AbstractScheduler;
import java.util.List;
import java.util.Map;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.JobParameters;

public class PushSendScheduler
extends AbstractScheduler<PushSendSchedule> {
    private static Logger logger = LoggerFactory.getLogger(PushSendScheduler.class);

    @Override
    protected void scheduleExecute(JobExecutionContext context) {
        JobDataMap jobDataMap = context.getMergedJobDataMap();
        String jobName = (String)jobDataMap.get("jobName");
        List scheduleList = this.scheduleService.getScheduleList();
        if (logger.isDebugEnabled()) {
            logger.debug("Push Send ScheduleCount:{}", (Object)scheduleList.size());
        }
        long runTime = System.currentTimeMillis();
        for (PushSendSchedule schedule : scheduleList) {
            jobDataMap.put("req.time", runTime / 5000L);
            jobDataMap.put("app.grp.key", schedule.getAppGrpKey());
            JobParameters jobParameters = this.getJobParametersFromJobMap((Map<String, Object>)jobDataMap);
            boolean isExist = this.jobRepository.isJobInstanceExists(jobName, jobParameters);
            if (isExist || this.scheduleService.isRunning(schedule.getAppGrpKey())) continue;
            try {
                this.scheduleService.setRunning(schedule.getAppGrpKey(), true);
                this.jobLauncher.run(this.jobLocator.getJob(jobName), jobParameters);
            }
            catch (Exception e) {
                logger.error("Could not execute job.", (Throwable)e);
                this.scheduleService.setRunning(schedule.getAppGrpKey(), false);
            }
        }
    }
}

