/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.batch.scheduler;

import com.humuson.tms.batch.domain.PushReSendSchedule;
import com.humuson.tms.batch.scheduler.AbstractScheduler;
import java.util.List;
import java.util.Map;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.JobParameters;

public class PushReSendScheduler
extends AbstractScheduler<PushReSendSchedule> {
    private static Logger logger = LoggerFactory.getLogger(PushReSendScheduler.class);

    @Override
    protected void scheduleExecute(JobExecutionContext context) {
        JobDataMap jobDataMap = context.getMergedJobDataMap();
        String jobName = (String)jobDataMap.get("jobName");
        List scheduleList = this.scheduleService.getScheduleList();
        if (logger.isDebugEnabled()) {
            logger.debug("Push ReSend ScheduleCount:{}", (Object)scheduleList.size());
        }
        jobDataMap.put("req.time", System.currentTimeMillis() / 10000L);
        jobDataMap.put("jobName", jobName);
        for (PushReSendSchedule schedule : scheduleList) {
            jobDataMap.put("app.grp.key", schedule.getAppGrpKey());
            jobDataMap.put("server.id", schedule.getServerId());
            jobDataMap.put("send.type", schedule.getSendType());
            jobDataMap.put("app.grp.id", schedule.getAppGrpId());
            JobParameters jobParameters = this.getJobParametersFromJobMap((Map<String, Object>)jobDataMap);
            logger.info("push resend jobParameters [{}]", (Object)jobParameters.toString());
            boolean isExist = this.jobRepository.isJobInstanceExists(jobName, jobParameters);
            if (isExist || this.scheduleService.isRunning(schedule.getKey())) continue;
            try {
                this.scheduleService.setRunning(schedule.getKey(), true);
                this.jobLauncher.run(this.jobLocator.getJob(jobName), jobParameters);
            }
            catch (Exception e) {
                logger.error("Could not execute job.", (Throwable)e);
                this.scheduleService.setRunning(schedule.getKey(), false);
            }
        }
    }
}

