/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.batch.scheduler;

import com.humuson.tms.batch.domain.PushFeedbackSchedule;
import com.humuson.tms.batch.scheduler.AbstractScheduler;
import java.util.List;
import java.util.Map;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.JobParameters;
import org.springframework.data.redis.core.StringRedisTemplate;

public class PushFeedbackScheduler
extends AbstractScheduler<PushFeedbackSchedule> {
    private static Logger logger = LoggerFactory.getLogger(PushFeedbackScheduler.class);
    private StringRedisTemplate redisTemplate;

    private long getFeedBackCountByAppKey(String appKey) {
        long feedbackSize = 0L;
        try {
            StringBuilder sb = new StringBuilder();
            String key = sb.append("feedbacks").append(":").append(appKey).toString();
            feedbackSize = this.redisTemplate.opsForList().size((Object)key);
        }
        catch (Exception e) {
            logger.error("redis Feedback Scheduler error : {}", (Throwable)e);
        }
        return feedbackSize;
    }

    @Override
    protected void scheduleExecute(JobExecutionContext context) {
        JobDataMap jobDataMap = context.getMergedJobDataMap();
        String jobName = (String)jobDataMap.get("jobName");
        List feedbackScheduleList = this.scheduleService.getScheduleList();
        this.redisTemplate = (StringRedisTemplate)this.ctx.getBean("redisTemplate");
        for (PushFeedbackSchedule feedbackSchedule : feedbackScheduleList) {
            long cnt = this.getFeedBackCountByAppKey(feedbackSchedule.getAppKey());
            if (this.scheduleService.isRunning(feedbackSchedule.getAppKey()) || cnt <= 0L) {
                logger.debug("TB_FEEDBACK_RAW [appKey:{}, size:{}] skip schedule!", (Object)feedbackSchedule.getAppKey(), (Object)cnt);
                continue;
            }
            jobDataMap.put("req.time", System.currentTimeMillis() / 10000L);
            jobDataMap.put("app.key", feedbackSchedule.getAppKey());
            jobDataMap.put("app.grp.id", feedbackSchedule.getAppGrpId());
            JobParameters jobParameters = this.getJobParametersFromJobMap((Map<String, Object>)jobDataMap);
            boolean isExist = this.jobRepository.isJobInstanceExists(jobName, jobParameters);
            if (isExist) continue;
            try {
                this.jobLauncher.run(this.jobLocator.getJob(jobName), jobParameters);
                this.scheduleService.setRunning(feedbackSchedule.getAppKey(), true);
                logger.debug("feedback job is launch!!!");
            }
            catch (Exception e) {
                logger.error("Could not execute job.", (Throwable)e);
                this.scheduleService.setRunning(feedbackSchedule.getAppKey(), false);
            }
        }
    }
}

