/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.batch.scheduler;

import com.humuson.tms.batch.domain.OptmzSchedule;
import com.humuson.tms.batch.scheduler.AbstractScheduler;
import com.humuson.tms.common.util.StringUtils;
import com.humuson.tms.constrants.StatusType;
import java.util.List;
import java.util.Map;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.JobParameters;

public class OptmzManualChnScheduler
extends AbstractScheduler<OptmzSchedule> {
    private static Logger logger = LoggerFactory.getLogger(OptmzManualChnScheduler.class);

    @Override
    protected void scheduleExecute(JobExecutionContext context) {
        JobDataMap jobDataMap = context.getMergedJobDataMap();
        String jobName = (String)jobDataMap.get("jobName");
        List scheduleList = this.scheduleService.getScheduleList();
        if (logger.isDebugEnabled()) {
            logger.debug("Manual Channel ScheduleCount:{}", (Object)scheduleList.size());
        }
        long runTime = System.currentTimeMillis();
        for (OptmzSchedule schedule : scheduleList) {
            if (schedule.getPPostId().equals(schedule.getPostId()) || this.scheduleService.isRunning(schedule.getPostId())) {
                if (!schedule.getPPostId().equals(schedule.getPostId())) continue;
                this.scheduleService.updateScheduleStatus(schedule.getPostId(), StatusType.COMPLETE.getCode());
                continue;
            }
            jobDataMap.put("req.time", runTime);
            jobDataMap.put("chn.type", schedule.getChannelType());
            jobDataMap.put("p.post.id", schedule.getPPostId());
            jobDataMap.put("post.id", schedule.getPostId());
            jobDataMap.put("msg.id", schedule.getMsgId());
            jobDataMap.put("optmz.target.type", schedule.getOptmzTargetType());
            jobDataMap.put("send.list.table", StringUtils.getSendListTable((String)schedule.getPostId()));
            jobDataMap.put("target.list.table", StringUtils.getSendListTable((String)schedule.getPPostId()));
            JobParameters jobParameters = this.getJobParametersFromJobMap((Map<String, Object>)jobDataMap);
            boolean isExist = this.jobRepository.isJobInstanceExists(jobName, jobParameters);
            if (isExist) continue;
            try {
                this.jobLauncher.run(this.jobLocator.getJob(jobName), jobParameters);
                this.scheduleService.setRunning(schedule.getPostId(), true);
                this.scheduleService.updateScheduleStatus(schedule.getPostId(), StatusType.SENDING.getCode());
            }
            catch (Exception e) {
                logger.error("Could not execute job.", (Throwable)e);
                this.scheduleService.updateScheduleStatus(schedule.getPostId(), StatusType.ERROR.getCode());
            }
        }
    }
}

