/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.batch.scheduler;

import com.humuson.tms.batch.domain.FatigueFilterSchedule;
import com.humuson.tms.batch.scheduler.AbstractScheduler;
import com.humuson.tms.batch.service.impl.FatigueFilterScheduleStatusUpdateService;
import com.humuson.tms.common.util.FatigueListTableNameUtil;
import com.humuson.tms.constrants.StatusType;
import java.util.List;
import java.util.Map;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.JobParameters;

public class FatigueFilterScheduler
extends AbstractScheduler<FatigueFilterSchedule> {
    private static final Logger log = LoggerFactory.getLogger(FatigueFilterScheduler.class);
    private static Logger logger = LoggerFactory.getLogger(FatigueFilterScheduler.class);
    FatigueFilterScheduleStatusUpdateService fatigueFilterScheduleStatusUpdateService;

    @Override
    public void init(JobExecutionContext context) throws JobExecutionException {
        super.init(context);
        this.fatigueFilterScheduleStatusUpdateService = (FatigueFilterScheduleStatusUpdateService)this.ctx.getBean("fatigueFilterScheduleStatusUpdateService", FatigueFilterScheduleStatusUpdateService.class);
    }

    @Override
    protected void scheduleExecute(JobExecutionContext context) {
        JobDataMap jobDataMap = context.getMergedJobDataMap();
        Object[] params = new Object[]{StatusType.FATIGUE_FILTER_RESERVE.getCode(), StatusType.FATIGUE_FILTER_RESERVE.getCode()};
        List scheduleList = this.scheduleService.getScheduleList(params);
        String jobName = jobDataMap.get((Object)"jobName").toString();
        long runTime = System.currentTimeMillis();
        for (FatigueFilterSchedule schedule : scheduleList) {
            jobDataMap.put("req.time", runTime);
            jobDataMap.put("send.type", schedule.getSendType());
            jobDataMap.put("post.id", schedule.getPostId());
            jobDataMap.put("server.id", schedule.getServerId());
            jobDataMap.put("site.id", schedule.getSiteId());
            jobDataMap.put("workday", schedule.getWorkday());
            jobDataMap.put("chn.type", schedule.getChannelType().getCode());
            jobDataMap.put("send.list.table", schedule.getListTable());
            jobDataMap.put("fatigue.list.table", FatigueListTableNameUtil.getFatigueListTableName((String)schedule.getChannelType().getCode()));
            FatigueFilterSchedule status = new FatigueFilterSchedule();
            status.setSendType(schedule.getSendType());
            status.setPostId(schedule.getPostId());
            status.setServerId(schedule.getServerId());
            JobParameters jobParameters = this.getJobParametersFromJobMap((Map<String, Object>)jobDataMap);
            boolean isExist = this.jobRepository.isJobInstanceExists(jobName, jobParameters);
            if (isExist || this.scheduleService.isRunning(schedule.getPostId())) continue;
            try {
                this.scheduleService.setRunning(schedule.getPostId(), true);
                status.setJobStatus(StatusType.FATIGUE_FILTER_ON.getCode());
                this.fatigueFilterScheduleStatusUpdateService.updateSchdlStatus(status);
                log.info("fatigue filter start. postId : {}, serverId : {}", (Object)schedule.getPostId(), (Object)schedule.getServerId());
                this.jobLauncher.run(this.jobLocator.getJob(jobName), jobParameters);
            }
            catch (Exception e) {
                logger.error("Could not execute job.", (Throwable)e);
                status.setJobStatus(StatusType.ERROR.getCode());
                this.fatigueFilterScheduleStatusUpdateService.updateSchdlStatus(status);
                this.scheduleService.setRunning(schedule.getPostId(), false);
            }
        }
    }
}

