/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.batch.scheduler;

import com.humuson.tms.batch.domain.DirectPushSendSchedule;
import com.humuson.tms.batch.scheduler.AbstractScheduler;
import java.util.List;
import java.util.Map;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.JobParameters;

public class DirectPushSendScheduler
extends AbstractScheduler<DirectPushSendSchedule> {
    private static Logger logger = LoggerFactory.getLogger(DirectPushSendScheduler.class);

    @Override
    protected void scheduleExecute(JobExecutionContext context) {
        JobDataMap jobDataMap = context.getMergedJobDataMap();
        String jobName = (String)jobDataMap.get("jobName");
        List scheduleList = this.scheduleService.getScheduleList();
        if (logger.isDebugEnabled()) {
            logger.debug("Push Send ScheduleCount:{}", (Object)scheduleList.size());
        }
        long runTime = System.currentTimeMillis() / 3000L;
        for (DirectPushSendSchedule schedule : scheduleList) {
            jobDataMap.put("req.time", runTime);
            jobDataMap.put("app.grp.key", schedule.getAppGrpKey());
            jobDataMap.put("app.grp.id", schedule.getAppGrpId());
            JobParameters jobParameters = this.getJobParametersFromJobMap((Map<String, Object>)jobDataMap);
            boolean isExist = this.jobRepository.isJobInstanceExists(jobName, jobParameters);
            if (isExist || this.scheduleService.isRunning(schedule.getAppGrpKey())) continue;
            try {
                this.scheduleService.setRunning(schedule.getAppGrpKey(), true);
                this.jobLauncher.run(this.jobLocator.getJob(jobName), jobParameters);
            }
            catch (Exception e) {
                logger.error("Could not execute job.", (Throwable)e);
                this.scheduleService.setRunning(schedule.getAppGrpKey(), false);
            }
        }
    }
}

