/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.batch.scheduler;

import com.humuson.tms.batch.domain.ApnsFeedbackSchedule;
import com.humuson.tms.batch.scheduler.AbstractScheduler;
import java.util.List;
import java.util.Map;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.JobParameters;

public class ApnsFeedbackJobScheduler
extends AbstractScheduler<ApnsFeedbackSchedule> {
    private static Logger logger = LoggerFactory.getLogger(ApnsFeedbackJobScheduler.class);

    @Override
    protected void scheduleExecute(JobExecutionContext context) {
        JobDataMap jobDataMap = context.getMergedJobDataMap();
        List scheduleList = this.scheduleService.getScheduleList();
        String jobName = (String)jobDataMap.get("jobName");
        long time = System.currentTimeMillis() / 300000L;
        jobDataMap.put("jobName", jobName);
        jobDataMap.put("req.time", time);
        for (ApnsFeedbackSchedule schedule : scheduleList) {
            jobDataMap.put("app.grp.key", schedule.getAppGrpKey());
            jobDataMap.put("app.grp.id", schedule.getAppGrpId());
            JobParameters jobParameters = this.getJobParametersFromJobMap((Map<String, Object>)jobDataMap);
            boolean isExist = this.jobRepository.isJobInstanceExists(jobName, jobParameters);
            if (isExist || this.scheduleService.isRunning(schedule.getAppGrpKey())) continue;
            try {
                this.scheduleService.setRunning(schedule.getAppGrpKey(), true);
                this.jobLauncher.run(this.jobLocator.getJob(jobName), jobParameters);
            }
            catch (Exception e) {
                logger.error("Could not execute job.", (Throwable)e);
                this.scheduleService.setRunning(schedule.getAppGrpKey(), false);
            }
        }
    }
}

