/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.batch.scheduler;

import com.humuson.tms.batch.domain.AndroidDelDeviceCleanzingSchedule;
import com.humuson.tms.batch.scheduler.AbstractScheduler;
import java.util.List;
import java.util.Map;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.JobExecutionException;
import org.springframework.batch.core.JobParameters;

public class AndroidDelDeviceCleanzingScheduler
extends AbstractScheduler<AndroidDelDeviceCleanzingSchedule> {
    private static Logger logger = LoggerFactory.getLogger(AndroidDelDeviceCleanzingScheduler.class);

    @Override
    protected void scheduleExecute(JobExecutionContext context) {
        JobDataMap jobDataMap = context.getMergedJobDataMap();
        String jobName = (String)jobDataMap.get("jobName");
        List androidDelUserScheduleList = this.scheduleService.getScheduleList();
        for (AndroidDelDeviceCleanzingSchedule androidDelUserSchedule : androidDelUserScheduleList) {
            boolean isExist;
            if (androidDelUserSchedule.getCount() == 0 || this.scheduleService.isRunning(jobName)) {
                logger.debug("AndroidDelUserSchedule not match if(data cnt :{} OR job is running :{})skip schedule!", (Object)androidDelUserSchedule.getCount(), (Object)this.scheduleService.isRunning(jobName));
                continue;
            }
            long time = System.currentTimeMillis() / 300000L;
            jobDataMap.put("jobName", jobName);
            jobDataMap.put("req.time", time);
            JobParameters jobParameters = this.getJobParametersFromJobMap((Map<String, Object>)jobDataMap);
            if (logger.isDebugEnabled()) {
                logger.debug("============================");
                logger.debug(jobParameters.toString());
                logger.debug("============================");
            }
            if (isExist = this.jobRepository.isJobInstanceExists(jobName, jobParameters)) continue;
            try {
                this.jobLauncher.run(this.jobLocator.getJob(jobName), jobParameters);
                this.scheduleService.setRunning(jobName, true);
                logger.info("AndroidDelUserSchedule job is launch!!!");
            }
            catch (JobExecutionException e) {
                logger.error("Could not execute job.", (Throwable)e);
            }
        }
    }
}

