/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.batch.scheduler;

import com.humuson.tms.batch.service.ScheduleService;
import com.humuson.tms.common.util.StringUtils;
import java.util.Date;
import java.util.Map;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.SchedulerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.JobParametersBuilder;
import org.springframework.batch.core.configuration.JobLocator;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.batch.core.launch.JobOperator;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.scheduling.quartz.QuartzJobBean;

public abstract class AbstractScheduler<T>
extends QuartzJobBean {
    private static Logger logger = LoggerFactory.getLogger(AbstractScheduler.class);
    protected JobLocator jobLocator;
    protected JobLauncher jobLauncher;
    protected JobRepository jobRepository;
    protected JobOperator jobOperator;
    protected ThreadPoolTaskExecutor excutor = null;
    protected ScheduleService<T> scheduleService;
    protected String scheduleServiceName;
    protected ApplicationContext ctx;
    protected static final String JOB_LOCATOR_CONTEXT_KEY = "jobLocator";
    protected static final String JOB_LAUNCHER_CONTEXT_KEY = "jobLauncher";
    protected static final String JOB_REPOSITORY_CONTEXT_KEY = "jobRepository";
    protected static final String JOB_OPERATOR_CONTEXT_KEY = "jobOperator";
    protected static final String APPLICATION_CONTEXT_KEY = "applicationContext";
    protected static final String JOB_NAME = "jobName";

    public void init(JobExecutionContext context) throws JobExecutionException {
        try {
            this.jobLocator = (JobLocator)context.getScheduler().getContext().get((Object)JOB_LOCATOR_CONTEXT_KEY);
            this.jobLauncher = (JobLauncher)context.getScheduler().getContext().get((Object)JOB_LAUNCHER_CONTEXT_KEY);
            this.jobRepository = (JobRepository)context.getScheduler().getContext().get((Object)JOB_REPOSITORY_CONTEXT_KEY);
            this.ctx = (ApplicationContext)context.getScheduler().getContext().get((Object)APPLICATION_CONTEXT_KEY);
            this.excutor = (ThreadPoolTaskExecutor)this.ctx.getBean("threadPoolTaskExecutor", ThreadPoolTaskExecutor.class);
            if (logger.isDebugEnabled()) {
                logger.debug("threadPoolTaskExecutor queue size :{}", (Object)this.excutor.getThreadPoolExecutor().getActiveCount());
            }
            if (!StringUtils.isNull((String)this.scheduleServiceName)) {
                this.scheduleService = (ScheduleService)this.ctx.getBean(this.scheduleServiceName);
            }
        }
        catch (SchedulerException e) {
            logger.error("Scheduler init error", (Throwable)e);
        }
    }

    protected abstract void scheduleExecute(JobExecutionContext var1) throws JobExecutionException;

    protected void executeInternal(JobExecutionContext context) throws JobExecutionException {
        this.init(context);
        this.scheduleExecute(context);
    }

    protected JobParameters getJobParametersFromJobMap(Map<String, Object> jobDataMap) {
        JobParametersBuilder builder = new JobParametersBuilder();
        for (Map.Entry<String, Object> entry : jobDataMap.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof String && !key.equals(JOB_NAME)) {
                builder.addString(key, (String)value);
                continue;
            }
            if (value instanceof Float || value instanceof Double) {
                builder.addDouble(key, Double.valueOf(((Number)value).doubleValue()));
                continue;
            }
            if (value instanceof Integer || value instanceof Long) {
                builder.addLong(key, Long.valueOf(((Number)value).longValue()));
                continue;
            }
            if (value instanceof Date) {
                builder.addDate(key, (Date)value);
                continue;
            }
            logger.debug("JobDataMap contains values which are not job parameters (ignoring). [key:{}, value:{}]", (Object)key, value);
        }
        return builder.toJobParameters();
    }

    @Autowired
    public void setScheduleServiceName(String scheduleServiceName) {
        this.scheduleServiceName = scheduleServiceName;
    }
}

