/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.batch.mapper;

import com.humuson.tms.common.model.target.TargetData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.RowMapper;

public class TargetDataRowMapper
implements RowMapper<TargetData> {
    private static final Logger log = LoggerFactory.getLogger(TargetDataRowMapper.class);
    private ResultSetMetaData rsmd;
    private int columnCount = 0;
    private Set<String> columnNameSet = new HashSet<String>();

    public TargetData mapRow(ResultSet rs, int rownum) throws SQLException {
        if (rownum <= 1 && this.rsmd == null) {
            this.rsmd = rs.getMetaData();
            this.columnCount = this.rsmd.getColumnCount();
            for (int i = 1; i <= this.columnCount; ++i) {
                if (log.isDebugEnabled()) {
                    log.debug("rsmd column name set [i:{}, name:{}]", (Object)i, (Object)this.rsmd.getColumnLabel(i));
                }
                this.columnNameSet.add(this.rsmd.getColumnLabel(i));
            }
        }
        TargetData userDataBean = new TargetData();
        for (String key : this.columnNameSet) {
            try {
                userDataBean.put(key, rs.getString(key));
            }
            catch (Exception e) {
                log.error("Column Not Found Exception [keySet:{}], error:{}", (Object)key, (Object)e.getMessage());
                throw new SQLException(String.format("Column Not Found Exception [keySet:%s]", key));
            }
        }
        return userDataBean;
    }
}

