/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.batch.mapper;

import com.humuson.tms.batch.domain.ChannelSendType;
import com.humuson.tms.batch.domain.PushResultLog;
import com.humuson.tms.common.util.StringUtils;
import com.humuson.tms.constrants.ChannelType;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.RowMapper;

public class PushQueueLogRowMapper
implements RowMapper<PushResultLog> {
    @Value(value="#{dbConfig['tms.jdbc.type']}")
    protected String dbType;

    public PushResultLog mapRow(ResultSet rs, int rownum) throws SQLException {
        int idx;
        PushResultLog pushResultLog = new PushResultLog();
        pushResultLog.setChannelType(ChannelType.PUSH);
        pushResultLog.setId(rs.getString("ID"));
        pushResultLog.setErrorCode(rs.getString("ERROR_CODE"));
        pushResultLog.setAppGrpId(rs.getInt("APP_GRP_ID"));
        pushResultLog.setRtnType(rs.getString("RTN_TYPE"));
        pushResultLog.setResultData(rs.getString("DATA"));
        pushResultLog.setReqUid(rs.getString("REQ_UID"));
        pushResultLog.setCustId(rs.getString("CUST_ID"));
        pushResultLog.setPostId(rs.getString("POST_ID"));
        pushResultLog.setListTable(rs.getString("LIST_TABLE"));
        pushResultLog.setMemberId(StringUtils.validString((String)rs.getString("MEMBER_ID")));
        pushResultLog.setChannelSendType(ChannelSendType.valueOf(rs.getString("CHANNEL_SEND_TYPE")));
        pushResultLog.setTdate(rs.getString("T_DATE"));
        pushResultLog.setDeliverTime(rs.getString("DELIVER_TIME"));
        pushResultLog.setAppOs(rs.getString("OS"));
        pushResultLog.setType(rs.getString("TYPE"));
        pushResultLog.setMonthDay(rs.getString("MMDD"));
        pushResultLog.setHour(rs.getString("HH24"));
        if ("ORACLE".equalsIgnoreCase(this.dbType)) {
            pushResultLog.setRowId(rs.getString("ROW_ID"));
        }
        if ("C".equals(pushResultLog.getRtnType()) && (idx = pushResultLog.getResultData().indexOf("^^")) > 0) {
            pushResultLog.setClickId(pushResultLog.getResultData().substring(0, idx));
            pushResultLog.setClickUrl(pushResultLog.getResultData().substring(idx + 2));
        }
        return pushResultLog;
    }
}

