/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.batch.mapper;

import com.humuson.tms.batch.domain.PushMessage;
import com.humuson.tms.batch.domain.PushQueue;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.RowMapper;

public class PushMqResendRowMapper
implements RowMapper<PushQueue> {
    private static final Logger log = LoggerFactory.getLogger(PushMqResendRowMapper.class);
    @Value(value="#{dbConfig['tms.jdbc.type']}")
    protected String dbType;

    public PushQueue mapRow(ResultSet rs, int rownum) throws SQLException {
        PushQueue pushQueue = new PushQueue();
        pushQueue.setAppGrpId(rs.getInt("APP_GRP_ID")).setAppId(rs.getInt("APP_ID")).setNotiFlag(rs.getString("NOTI_FLAG")).setAppGrpKey(rs.getString("APP_GRP_KEY")).setReqUid(rs.getString("REQ_UID")).setCustId(rs.getString("CUST_ID")).setDeviceId(rs.getInt("DEVICE_ID")).setPushToken(rs.getString("PUSH_TOKEN")).setPushType(rs.getString("PUSH_TYPE")).setSendStatus(rs.getString("SEND_STATUS")).setErrorCode(rs.getString("ERROR_CODE")).setServerId(rs.getString("SERVER_ID"));
        PushMessage pushMessage = new PushMessage();
        pushMessage.setPushTitle(rs.getString("PUSH_TITLE")).setExpireDate(rs.getString("EXPIRE_DATE")).setPushMsg(rs.getString("PUSH_MSG")).setMsgType(rs.getString("MSG_TYPE")).setMsgUid(rs.getString("MSG_UID")).setInAppContent(rs.getString("INAPP_CONTENT")).setPopupContent(rs.getString("POPUP_CONTENT")).setPushImg(rs.getString("PUSH_IMG")).setPushKey(rs.getString("PUSH_KEY")).setPushValue(rs.getString("PUSH_VALUE")).setEtc1(rs.getString("ETC1")).setEtc2(rs.getString("ETC2")).setEtc3(rs.getString("ETC3")).setEtc4(rs.getString("ETC4")).setEtc5(rs.getString("ETC5")).setEtc6(rs.getString("ETC6"));
        if ("ORACLE".equalsIgnoreCase(this.dbType)) {
            pushQueue.setRowId(rs.getString("ROW_ID"));
        }
        pushQueue.setPushMessage(pushMessage);
        if (log.isDebugEnabled()) {
            log.debug("pushQueue {}", (Object)pushQueue.toString());
        }
        return pushQueue;
    }
}

