/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.batch.mapper;

import com.humuson.tms.common.model.target.TargetData;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.item.file.mapping.FieldSetMapper;
import org.springframework.batch.item.file.transform.FieldSet;
import org.springframework.validation.BindException;

public class FileTargetDataRowMapper
implements FieldSetMapper<TargetData> {
    private static final Logger log = LoggerFactory.getLogger(FileTargetDataRowMapper.class);
    private int fieldSetCount = 0;
    private List<Integer> targetFileIdxList = new ArrayList<Integer>();

    public TargetData mapFieldSet(FieldSet fieldSet) throws BindException {
        if (this.fieldSetCount == 0) {
            this.fieldSetCount = fieldSet.getFieldCount();
        }
        if (log.isDebugEnabled()) {
            log.debug("fieldSet names:{}, values:{}", (Object)fieldSet.getNames().length, (Object)fieldSet.getValues().length);
        }
        String[] names = fieldSet.getNames();
        String[] values = fieldSet.getValues();
        TargetData userDataBean = new TargetData();
        try {
            int size = this.targetFileIdxList.size();
            for (int i = 0; i < size; ++i) {
                if (this.targetFileIdxList.get(i) < 0) continue;
                userDataBean.put(names[i], values[this.targetFileIdxList.get(i)]);
            }
        }
        catch (Exception e) {
            log.error("target data bind error [{}]", (Object)fieldSet.getProperties().toString());
            throw new BindException((Object)this, "fieldSetBind Error");
        }
        return userDataBean;
    }

    public void setTargetFileIdx(String targetFileIdx) {
        for (String idx : targetFileIdx.split("[|]")) {
            try {
                this.targetFileIdxList.add(Integer.parseInt(idx));
            }
            catch (Exception e) {
                log.error("idx parse error [targetFileIdx:{}, idx:{}]", (Object)targetFileIdx, (Object)idx);
                this.targetFileIdxList.add(-1);
            }
        }
    }
}

