/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.batch.mapper;

import com.humuson.tms.batch.domain.DirectQueue;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.RowMapper;

public class DirectQueueRowMapper
implements RowMapper<DirectQueue> {
    private static final Logger log = LoggerFactory.getLogger(DirectQueueRowMapper.class);
    @Value(value="#{dbConfig['tms.jdbc.type']}")
    protected String dbType;

    public DirectQueue mapRow(ResultSet rs, int rownum) throws SQLException {
        DirectQueue item = new DirectQueue();
        item.setSeq(rs.getLong("SEQ"));
        item.setAppGrpId(rs.getInt("APP_GRP_ID"));
        item.setAppGrpKey(rs.getString("APP_GRP_KEY"));
        item.setChGubun(rs.getString("CH_GUBUN"));
        item.setDeviceId(rs.getLong("DEVICE_ID"));
        item.setCustId(rs.getString("TMS_M_ID"));
        item.setCustName(rs.getString("TMS_M_NAME"));
        item.setPushToken(rs.getString("TMS_M_TOKEN"));
        item.setSubject(rs.getString("SUBJECT"));
        item.setContent(rs.getString("CONTENT"));
        item.setInappMsg(rs.getString("PU_IN_APP"));
        item.setPushValue(rs.getString("PUSH_VALUE"));
        item.setImgUrl(rs.getString("IMG_URL"));
        item.setRegDate(rs.getString("REG_DATE"));
        item.setMsgTpCd(rs.getString("MSG_TP_CD"));
        item.setReqUid(rs.getString("REQ_UID"));
        item.setPriority(rs.getInt("PRIORITY"));
        item.setToId(rs.getString("TO_ID"));
        item.setTtl(rs.getInt("TTL"));
        item.setNotiFlag(rs.getString("NOTI_FLAG"));
        item.setAppOs(rs.getString("OS"));
        return item;
    }
}

