/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.batch.mapper;

import com.humuson.tms.common.model.target.TargetData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.RowMapper;

public class DbTargetDataRowMapper
implements RowMapper<TargetData> {
    private static final Logger log = LoggerFactory.getLogger(DbTargetDataRowMapper.class);
    private ResultSetMetaData rsmd;
    private int columnCount = 0;
    private Set<String> columnNameSet = new HashSet<String>();

    public TargetData mapRow(ResultSet rs, int rownum) throws SQLException {
        if (rownum == 0) {
            this.rsmd = rs.getMetaData();
            this.columnCount = this.rsmd.getColumnCount();
            for (int i = 1; i <= this.columnCount; ++i) {
                log.info("rsmd column name set [i:{}, name:{}]", (Object)i, (Object)this.rsmd.getColumnLabel(i));
                this.columnNameSet.add(this.rsmd.getColumnLabel(i));
            }
        }
        TargetData userDataBean = new TargetData();
        try {
            for (String key : this.columnNameSet) {
                userDataBean.put(key, rs.getString(key));
            }
        }
        catch (Exception e) {
            throw new SQLException("Column Not Found Exception");
        }
        return userDataBean;
    }
}

