/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.batch.job.tasklet;

import com.humuson.tms.batch.domain.SiteInfo;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.repeat.RepeatStatus;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public class SendTargetSummaryTasklet
implements Tasklet {
    @Autowired
    private JdbcTemplate jdbcTemplate;
    private String selectPushUserCount;
    private String selectUserCount;
    private String updateUserCount;
    private final String PUSH = "pushCount";
    private final String SMS = "smsCount";
    private final String EMAIL = "emailCount";
    Logger logger = LoggerFactory.getLogger(SendTargetSummaryTasklet.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RepeatStatus execute(StepContribution stepContribution, ChunkContext chunkContext) throws Exception {
        SiteInfo siteInfo;
        List targetCountList = this.jdbcTemplate.query(this.selectUserCount, (RowMapper)new RowMapper<SiteInfo>(){

            public SiteInfo mapRow(ResultSet rs, int rowNum) throws SQLException {
                SiteInfo siteInfo = new SiteInfo();
                siteInfo.setSiteId(rs.getInt("SITE_ID"));
                siteInfo.setEmailUserCnt(rs.getLong("EMAIL_USER_CNT"));
                siteInfo.setSmsUserCnt(rs.getLong("SMS_USER_CNT"));
                return siteInfo;
            }
        });
        List pushCountList = this.jdbcTemplate.query(this.selectPushUserCount, (RowMapper)new RowMapper<SiteInfo>(){

            public SiteInfo mapRow(ResultSet rs, int rowNum) throws SQLException {
                SiteInfo siteInfo = new SiteInfo();
                siteInfo.setSiteId(rs.getInt("SITE_ID"));
                siteInfo.setPushUserCnt(rs.getLong("PUSH_USER_CNT"));
                return siteInfo;
            }
        });
        HashMap<Integer, SiteInfo> countMap = new HashMap<Integer, SiteInfo>();
        for (SiteInfo pushCount : pushCountList) {
            try {
                siteInfo = (SiteInfo)countMap.get(pushCount.getSiteId());
                if (siteInfo == null) {
                    siteInfo = new SiteInfo();
                }
                siteInfo.setPushUserCnt(pushCount.getPushUserCnt());
                countMap.put(pushCount.getSiteId(), siteInfo);
            }
            catch (Exception e) {
                this.logger.error("update user_count error", (Throwable)e);
            }
        }
        for (SiteInfo targetCount : targetCountList) {
            try {
                siteInfo = (SiteInfo)countMap.get(targetCount.getSiteId());
                if (siteInfo == null) {
                    siteInfo = new SiteInfo();
                }
                siteInfo.setEmailUserCnt(targetCount.getEmailUserCnt());
                siteInfo.setSmsUserCnt(targetCount.getSmsUserCnt());
                countMap.put(targetCount.getSiteId(), siteInfo);
            }
            catch (Exception e) {
                this.logger.error("update user_count error", (Throwable)e);
            }
        }
        Iterator<Object> iterator = countMap.keySet().iterator();
        while (iterator.hasNext()) {
            int key = (Integer)iterator.next();
            long smsUserCnt = ((SiteInfo)countMap.get(key)).getSmsUserCnt();
            long emailUserCnt = ((SiteInfo)countMap.get(key)).getEmailUserCnt();
            long pushUserCnt = ((SiteInfo)countMap.get(key)).getPushUserCnt();
            long totalUserCnt = smsUserCnt + emailUserCnt + pushUserCnt;
            this.jdbcTemplate.update(this.updateUserCount, new Object[]{smsUserCnt, emailUserCnt, pushUserCnt, totalUserCnt, key});
        }
        return RepeatStatus.FINISHED;
    }

    public void setSelectPushUserCount(String selectPushUserCount) {
        this.selectPushUserCount = selectPushUserCount;
    }

    public void setSelectUserCount(String selectUserCount) {
        this.selectUserCount = selectUserCount;
    }

    public void setUpdateUserCount(String updateUserCount) {
        this.updateUserCount = updateUserCount;
    }
}

