/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.batch.job.tasklet;

import com.humuson.amc.client.AmcClient;
import com.humuson.amc.client.model.AudienceScrollResponse;
import com.humuson.amc.client.model.request.ContactRequest;
import com.humuson.tms.batch.service.ComposeTargetSqlService;
import com.humuson.tms.batch.service.PostIdDevideService;
import com.humuson.tms.batch.service.TargetServerService;
import com.humuson.tms.common.model.target.TargetCondInfo;
import com.humuson.tms.common.model.target.TargetDbInfo;
import com.humuson.tms.common.model.target.TargetFileInfo;
import com.humuson.tms.common.model.target.TargetInfo;
import com.humuson.tms.constrants.ChannelType;
import com.humuson.tms.constrants.TargetType;
import com.mchange.v2.c3p0.ComboPooledDataSource;
import java.beans.PropertyVetoException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.repeat.RepeatStatus;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public class InitTargetingTasklet
implements Tasklet,
StepExecutionListener {
    private static final Logger log = LoggerFactory.getLogger(InitTargetingTasklet.class);
    private StepExecution stepExecution;
    private String selectTargetInfo;
    private String updateTargetInfo;
    private String updateTargetTotalInfo;
    private String deleteSendList;
    private String deleteAmcTargetList;
    private String deleteTargetData;
    private String emailMappingHeader;
    private String smsMappingHeader;
    private String pushMappingHeader;
    private String totalMappingHeader;
    private String amcMappingHeader;
    private String selectAmcSiteKeyInfo;
    private String amcBaseUrl;
    @Value(value="#{config['target.file.upload.path']}")
    private String fileUploadPath;
    @Autowired
    TargetServerService targetServerService;
    @Autowired
    PostIdDevideService postIdDevideService;
    @Autowired
    ComposeTargetSqlService composeTargetSqlService;
    @Autowired
    private JdbcTemplate jdbcTemplate;
    private AmcClient client;
    protected static final String XLS = "xls";
    protected static final String XLSX = "xlsx";
    protected static final String ALL_DEVICE = "A";
    protected static final String LOGIN_DEVICE = "L";

    public RepeatStatus execute(StepContribution contribution, ChunkContext chunkContext) throws Exception {
        String postId = this.stepExecution.getJobParameters().getString("post.id");
        String msgId = this.stepExecution.getJobParameters().getString("msg.id");
        String targetType = this.stepExecution.getJobParameters().getString("target.type");
        String channelType = this.stepExecution.getJobParameters().getString("chn.type");
        String listTable = this.stepExecution.getJobParameters().getString("send.list.table");
        String deduplicationYn = this.stepExecution.getJobParameters().getString("deduplication.yn");
        log.info("InitTargetingTasklet start [channel:{}, postId:{}, targetType:{}, deduplicationYn:{}]", new Object[]{channelType, postId, targetType, deduplicationYn});
        TargetInfo targetInfo = this.getTargetInfo(targetType, channelType, msgId);
        targetInfo.setTargetType(targetType).setPostId(postId);
        this.stepExecution.getJobExecution().getExecutionContext().put("chn.type", (Object)channelType);
        this.stepExecution.getJobExecution().getExecutionContext().put("send.list.table", (Object)listTable);
        this.stepExecution.getJobExecution().getExecutionContext().put("add.site.user.yn", (Object)targetInfo.getAddSiteUserYn());
        int targetCnt = 0;
        this.stepExecution.getJobExecution().getExecutionContext().put("app.grp.id", (Object)targetInfo.getAppGrpId());
        if (TargetType.FILE.getCode().equals(targetInfo.getTargetType())) {
            int lineToSkipCount = 0;
            String targetFileName = targetInfo.getTargetFileInfo().getFileName();
            String fileCharSet = targetInfo.getTargetFileInfo().getFileCharSet();
            String fileIdx = targetInfo.getTargetFileInfo().getFileIdx();
            this.stepExecution.getJobExecution().getExecutionContext().put("charSet", (Object)fileCharSet);
            this.stepExecution.getJobExecution().getExecutionContext().put("id.target.yn", (Object)targetInfo.getIdTargetYn());
            this.stepExecution.getJobExecution().getExecutionContext().put("file.name", (Object)targetFileName);
            this.stepExecution.getJobExecution().getExecutionContext().put("target.file.idx", (Object)fileIdx);
            this.stepExecution.getJobExecution().getExecutionContext().put("charSet", (Object)targetInfo.getTargetFileInfo().getFileCharSet());
            if ("Y".equals(targetInfo.getTargetFileInfo().getTargetFileHeadFlag())) {
                lineToSkipCount = 1;
            }
            this.stepExecution.getJobExecution().getExecutionContext().put("delimiter", (Object)targetInfo.getTargetFileInfo().getFileDelim());
            if (ChannelType.EMAIL.getCode().equals(channelType)) {
                this.stepExecution.getJobExecution().getExecutionContext().put("header", (Object)this.emailMappingHeader);
            } else if (ChannelType.SMS.getCode().equals(channelType)) {
                this.stepExecution.getJobExecution().getExecutionContext().put("header", (Object)this.smsMappingHeader);
            } else if (ChannelType.PUSH.getCode().equals(channelType)) {
                this.stepExecution.getJobExecution().getExecutionContext().put("header", (Object)this.pushMappingHeader);
            } else if (ChannelType.TOTAL.getCode().equals(channelType)) {
                this.stepExecution.getJobExecution().getExecutionContext().put("header", (Object)this.totalMappingHeader);
            }
            this.stepExecution.getJobExecution().getExecutionContext().put("lines.to.skip", (Object)String.valueOf(lineToSkipCount));
            targetCnt = this.getTargetFileLineCount(targetInfo.getTargetFileInfo().getFileName(), targetInfo.getTargetCnt(), lineToSkipCount);
        } else if (TargetType.DB.getCode().equals(targetInfo.getTargetType())) {
            this.stepExecution.getJobExecution().getExecutionContext().put("sql", (Object)targetInfo.getTargetQuery());
            if (targetInfo.getTargetDbInfo() != null) {
                this.stepExecution.getJobExecution().getExecutionContext().put("jdbc.type", (Object)targetInfo.getTargetDbInfo().getDbType());
                this.stepExecution.getJobExecution().getExecutionContext().put("jdbc.driver", (Object)targetInfo.getTargetDbInfo().getDbDriver());
                this.stepExecution.getJobExecution().getExecutionContext().put("jdbc.url", (Object)targetInfo.getTargetDbInfo().getDbUrl());
                this.stepExecution.getJobExecution().getExecutionContext().put("jdbc.user", (Object)targetInfo.getTargetDbInfo().getDbUser());
                this.stepExecution.getJobExecution().getExecutionContext().put("jdbc.password", (Object)targetInfo.getTargetDbInfo().getDbPassword());
            }
            targetCnt = this.getTargetDBTargetCnt(targetInfo);
        } else if (TargetType.COND.getCode().equals(targetInfo.getTargetType())) {
            this.stepExecution.getJobExecution().getExecutionContext().put("android.id", (Object)targetInfo.getTargetCondInfo().getAndroidAppId());
            this.stepExecution.getJobExecution().getExecutionContext().put("ios.id", (Object)targetInfo.getTargetCondInfo().getIOsAppId());
            this.stepExecution.getJobExecution().getExecutionContext().put("s.date", (Object)targetInfo.getTargetCondInfo().getSessionStartDate());
            this.stepExecution.getJobExecution().getExecutionContext().put("e.date", (Object)targetInfo.getTargetCondInfo().getSessionEndDate());
            if (ALL_DEVICE.equals(targetInfo.getUseLogin()) && "unpass".equalsIgnoreCase(this.stepExecution.getJobExecution().getExecutionContext().getString("taget.all.device.step1", "unpass"))) {
                targetInfo.setUseLogin(LOGIN_DEVICE);
                targetCnt += this.composeTargetSqlService.getCondTargetCount(msgId, channelType, targetInfo, this.stepExecution.getJobExecution().getExecutionContext());
                targetInfo.setUseLogin(ALL_DEVICE);
            }
            targetCnt += this.composeTargetSqlService.getCondTargetCount(msgId, channelType, targetInfo, this.stepExecution.getJobExecution().getExecutionContext());
        } else if (TargetType.REL.getCode().equals(targetInfo.getTargetType())) {
            this.stepExecution.getJobExecution().getExecutionContext().put("sql", (Object)targetInfo.getTargetQuery());
            targetCnt = (Integer)this.jdbcTemplate.queryForObject("select count(*) from (" + targetInfo.getTargetQuery() + ") tmp", Integer.class);
        } else if (TargetType.AMC.getCode().equals(targetInfo.getTargetType())) {
            Map keyInfo = this.jdbcTemplate.queryForMap(this.selectAmcSiteKeyInfo, new Object[]{targetInfo.getSiteId()});
            if (ChannelType.PUSH.getCode().equals(channelType) || ChannelType.PUSH.getCode().equals(targetInfo.getFirstChannelType())) {
                this.stepExecution.getJobExecution().getExecutionContext().put("android.id", (Object)targetInfo.getTargetCondInfo().getAndroidAppId());
                this.stepExecution.getJobExecution().getExecutionContext().put("ios.id", (Object)targetInfo.getTargetCondInfo().getIOsAppId());
                this.stepExecution.getJobExecution().getExecutionContext().put("s.date", (Object)targetInfo.getTargetCondInfo().getSessionStartDate());
                this.stepExecution.getJobExecution().getExecutionContext().put("e.date", (Object)targetInfo.getTargetCondInfo().getSessionEndDate());
                this.composeTargetSqlService.getCondTargetCount(msgId, channelType, targetInfo, this.stepExecution.getJobExecution().getExecutionContext());
                this.stepExecution.getJobExecution().getExecutionContext().put("chn.type", (Object)ChannelType.PUSH.getCode());
            } else {
                String sql = "select ATUL.CUST_ID TMS_M_ID, CUST_NAME TMS_M_NAME, CUST_EMAIL TMS_M_EMAIL, CUST_PHONE TMS_M_PHONE FROM TMS_AMC_TARGETING_USER_LIST ATUL  LEFT JOIN  TMS_SITE_USER_LIST SUL ON ( ATUL.CUST_ID = SUL.CUST_ID AND SITE_ID = " + targetInfo.getSiteId() + ")  WHERE MSG_ID = " + msgId;
                this.stepExecution.getJobExecution().getExecutionContext().put("sql", (Object)sql);
            }
            this.stepExecution.getJobExecution().getExecutionContext().put("amc.audience.seq", (Object)targetInfo.getAudienceSeq());
            this.stepExecution.getJobExecution().getExecutionContext().put("amc.site.key", keyInfo.get("AMC_SITE_KEY"));
            this.stepExecution.getJobExecution().getExecutionContext().put("amc.web.key", keyInfo.get("AMC_WEB_KEY"));
            this.client = this.amcBaseUrl != null ? new AmcClient.Builder().setBaseUri(this.amcBaseUrl).build() : new AmcClient.Builder().setBaseUri("http://119.207.76.91:7082/api").build();
            ContactRequest req = new ContactRequest();
            req.setSize(1);
            req.setAudienceSeq(String.valueOf(targetInfo.getAudienceSeq()));
            req.setTimeout(Integer.valueOf(20000));
            targetCnt = ((AudienceScrollResponse)this.client.contact.get(req).get()).getTotalCount();
        }
        if (!"pass".equalsIgnoreCase(this.stepExecution.getJobExecution().getExecutionContext().getString("taget.all.device.step1", "unpass"))) {
            this.removePrevTargetData(msgId, targetInfo, channelType, targetCnt);
        }
        this.stepExecution.getJobExecution().getExecutionContext().put("encrypt.yn", (Object)targetInfo.getEncryptYn());
        this.stepExecution.getJobExecution().getExecutionContext().put("site.id", (Object)targetInfo.getSiteId());
        this.stepExecution.getJobExecution().getExecutionContext().put("tot.cnt", (Object)targetCnt);
        this.stepExecution.getJobExecution().getExecutionContext().put("1st.chn.type", (Object)targetInfo.getFirstChannelType());
        this.stepExecution.getJobExecution().getExecutionContext().put("mkt.yn", (Object)targetInfo.getMktYn());
        this.stepExecution.getJobExecution().getExecutionContext().put("deduplication.yn", (Object)targetInfo.getDeduplicationYn());
        this.stepExecution.getJobExecution().getExecutionContext().put("seq.no", (Object)targetInfo.getSeqNo());
        log.info("jobExecutionContext [{}]", (Object)this.stepExecution.getJobExecution().getExecutionContext().toString());
        return RepeatStatus.FINISHED;
    }

    private int getTargetDBTargetCnt(TargetInfo targetInfo) throws PropertyVetoException {
        ComboPooledDataSource dataSource = new ComboPooledDataSource();
        dataSource.setDriverClass(targetInfo.getTargetDbInfo().getDbDriver());
        dataSource.setJdbcUrl(targetInfo.getTargetDbInfo().getDbUrl());
        dataSource.setUser(targetInfo.getTargetDbInfo().getDbUser());
        dataSource.setPassword(targetInfo.getTargetDbInfo().getDbPassword());
        JdbcTemplate targetJdbcTemplate = new JdbcTemplate((DataSource)dataSource);
        int targetCnt = (Integer)targetJdbcTemplate.queryForObject("select count(*) from (" + targetInfo.getTargetQuery() + ") tmp", Integer.class);
        return targetCnt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getTargetFileLineCount(String fileName, int prevTargetCount, int lineToSkipCount) throws IOException {
        int targetCnt;
        try (BufferedReader lnr = null;){
            lnr = new LineNumberReader(new FileReader(new File(this.fileUploadPath.concat(File.separator).concat(fileName))));
            ((LineNumberReader)lnr).skip(Long.MAX_VALUE);
            log.info("lineNumber:{}, lineToSkipCount:{}", (Object)((LineNumberReader)lnr).getLineNumber(), (Object)lineToSkipCount);
            targetCnt = prevTargetCount + ((LineNumberReader)lnr).getLineNumber() - lineToSkipCount + 1;
        }
        return targetCnt;
    }

    private void removePrevTargetData(String msgId, TargetInfo targetInfo, String channelType, int targetCnt) {
        if ("N".equals(targetInfo.getNextTarget())) {
            ArrayList<String> postIdList = new ArrayList<String>();
            if ("Y".equals(targetInfo.getAbTestFileYn())) {
                List<Properties> list = this.postIdDevideService.getAbTestPostIds(msgId, targetInfo.getPostId());
                for (Properties prop : list) {
                    postIdList.add(prop.getProperty("POST_ID"));
                }
            } else {
                postIdList.add(targetInfo.getPostId());
            }
            int count = 0;
            int totalDeleteCount = 0;
            for (String postId : postIdList) {
                this.targetServerService.initTargetServerInfo(postId);
                count = 0;
                totalDeleteCount = 0;
                do {
                    count = this.jdbcTemplate.update(this.deleteSendList, new Object[]{postId});
                    log.info("prev target date remove...[postId:{}, count:{}]", (Object)postId, (Object)(totalDeleteCount += count));
                } while (count > 0);
            }
            count = 0;
            totalDeleteCount = 0;
            if (TargetType.AMC.getCode().equals(targetInfo.getTargetType())) {
                do {
                    count = this.jdbcTemplate.update(this.deleteAmcTargetList, new Object[]{msgId});
                    log.info("prev amc target date remove...[msgId:{}, count:{}]", (Object)msgId, (Object)(totalDeleteCount += count));
                } while (count > 0);
            }
            this.jdbcTemplate.update(this.updateTargetInfo, new Object[]{targetCnt, msgId});
        }
    }

    private TargetInfo getTargetInfo(final String targetType, final String channelType, String msgId) {
        return (TargetInfo)this.jdbcTemplate.queryForObject(this.selectTargetInfo, (RowMapper)new RowMapper<TargetInfo>(){

            public TargetInfo mapRow(ResultSet rs, int rowNum) throws SQLException {
                TargetCondInfo targetCondInfo;
                TargetInfo targetInfo = new TargetInfo();
                targetInfo.setTargetType(targetType);
                if (TargetType.DB.getCode().equals(targetType)) {
                    TargetDbInfo targetDbInfo = new TargetDbInfo();
                    targetDbInfo.setDbDriver(rs.getString("DB_DRV")).setDbType(rs.getString("DB_TYPE")).setDbUrl(rs.getString("DB_URL")).setDbUser(rs.getString("DB_USR")).setDbPassword(rs.getString("DB_PWD"));
                    targetInfo.setTargetDbInfo(targetDbInfo);
                    targetInfo.setTargetQuery(rs.getString("TARGET_DB_QUERY"));
                } else if (TargetType.FILE.getCode().equals(targetType)) {
                    TargetFileInfo targetFileInfo = new TargetFileInfo();
                    targetFileInfo.setFileName(rs.getString("TARGET_FILE_NAME")).setFileDelim(rs.getString("TARGET_FILE_DELIM")).setFileIdx(rs.getString("TARGET_FILE_IDX")).setTargetFileHeadFlag(rs.getString("TARGET_FILE_HEAD_FLAG")).setFileCharSet(rs.getString("TARGET_FILE_ENCODING"));
                    targetInfo.setTargetFileInfo(targetFileInfo).setIdTargetYn(rs.getString("ID_TARGET_YN"));
                } else if (TargetType.COND.getCode().equals(targetType)) {
                    targetCondInfo = new TargetCondInfo();
                    targetCondInfo.setAndroidAppId(rs.getInt("ANDROID_APP_ID"));
                    targetCondInfo.setIOsAppId(rs.getInt("IOS_APP_ID"));
                    targetCondInfo.setAppGrpId(rs.getInt("APP_GRP_ID"));
                    targetCondInfo.setSessionStartDate(rs.getString("APP_SESS_START"));
                    targetCondInfo.setSessionEndDate(rs.getString("APP_SESS_END"));
                    targetInfo.setUsePlatform(rs.getString("USE_PLATFORM"));
                    targetInfo.setUseCondition(rs.getString("USE_CONDITION"));
                    targetInfo.setTargetCondInfo(targetCondInfo);
                } else if (TargetType.REL.getCode().equals(targetType)) {
                    targetInfo.setTargetQuery(rs.getString("TARGET_DB_QUERY"));
                }
                if (TargetType.AMC.getCode().equals(targetType)) {
                    if (ChannelType.PUSH.getCode().equals(channelType)) {
                        targetCondInfo = new TargetCondInfo();
                        targetCondInfo.setAndroidAppId(rs.getInt("ANDROID_APP_ID"));
                        targetCondInfo.setIOsAppId(rs.getInt("IOS_APP_ID"));
                        targetCondInfo.setAppGrpId(rs.getInt("APP_GRP_ID"));
                        targetCondInfo.setSessionStartDate(rs.getString("APP_SESS_START"));
                        targetCondInfo.setSessionEndDate(rs.getString("APP_SESS_END"));
                        targetInfo.setUsePlatform(rs.getString("USE_PLATFORM"));
                        targetInfo.setUseCondition(rs.getString("USE_CONDITION"));
                        targetInfo.setTargetCondInfo(targetCondInfo);
                    }
                    targetInfo.setAudienceSeq(rs.getInt("AUDIENCE_SEQ"));
                }
                targetInfo.setUseLogin(rs.getString("USE_LOGIN"));
                targetInfo.setMktYn(rs.getString("MKT_YN"));
                targetInfo.setEncryptYn(rs.getString("ENCRYPT_YN"));
                targetInfo.setSiteId(rs.getInt("SITE_ID"));
                targetInfo.setTargetCnt(rs.getInt("TARGET_CNT"));
                targetInfo.setAppGrpId(rs.getInt("APP_GRP_ID"));
                targetInfo.setWhereInfo(rs.getString("WHERE_INFO")).setNextTarget(rs.getString("NEXT_TARGET_YN")).setAbTestFileYn(rs.getString("AB_TEST_YN")).setAddSiteUserYn(rs.getString("ADD_SITE_USER_YN")).setFirstChannelType(rs.getString("FIRST_CHANNEL_TYPE"));
                targetInfo.setSeqNo(rs.getString("SEQNO"));
                return targetInfo;
            }
        }, new Object[]{msgId});
    }

    public void beforeStep(StepExecution stepExecution) {
        this.stepExecution = stepExecution;
    }

    public ExitStatus afterStep(StepExecution stepExecution) {
        return stepExecution.getExitStatus();
    }

    public void setSelectTargetInfo(String selectTargetInfo) {
        this.selectTargetInfo = selectTargetInfo;
    }

    public void setUpdateTargetInfo(String updateTargetInfo) {
        this.updateTargetInfo = updateTargetInfo;
    }

    public void setUpdateTargetTotalInfo(String updateTargetTotalInfo) {
        this.updateTargetTotalInfo = updateTargetTotalInfo;
    }

    public void setDeleteSendList(String deleteSendList) {
        this.deleteSendList = deleteSendList;
    }

    public void setDeleteAmcTargetList(String deleteAmcTargetList) {
        this.deleteAmcTargetList = deleteAmcTargetList;
    }

    public void setDeleteTargetData(String deleteTargetData) {
        this.deleteTargetData = deleteTargetData;
    }

    public void setEmailMappingHeader(String emailMappingHeader) {
        this.emailMappingHeader = emailMappingHeader;
    }

    public void setSmsMappingHeader(String smsMappingHeader) {
        this.smsMappingHeader = smsMappingHeader;
    }

    public void setPushMappingHeader(String pushMappingHeader) {
        this.pushMappingHeader = pushMappingHeader;
    }

    public void setTotalMappingHeader(String totalMappingHeader) {
        this.totalMappingHeader = totalMappingHeader;
    }

    public void setAmcMappingHeader(String amcMappingHeader) {
        this.amcMappingHeader = amcMappingHeader;
    }

    public void setSelectAmcSiteKeyInfo(String selectAmcSiteKeyInfo) {
        this.selectAmcSiteKeyInfo = selectAmcSiteKeyInfo;
    }

    public void setAmcBaseUrl(String amcBaseUrl) {
        this.amcBaseUrl = amcBaseUrl;
    }
}

