/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.batch.job.tasklet;

import com.humuson.tms.batch.domain.App;
import com.humuson.tms.batch.domain.PushMessage;
import com.humuson.tms.batch.service.PushInfoService;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.repeat.RepeatStatus;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;

public class InitPushSendTasklet
implements Tasklet {
    private static final Logger log = LoggerFactory.getLogger(InitPushSendTasklet.class);
    @Autowired
    protected JdbcTemplate jdbcTemplate;
    protected String selectMinMaxId;
    @Autowired
    PushInfoService<App, PushMessage> pushInfoServiceImpl;

    public RepeatStatus execute(StepContribution stepContribution, ChunkContext chunkContext) throws Exception {
        String appGrpKey = chunkContext.getStepContext().getStepExecution().getJobParameters().getString("app.grp.key");
        Map map = null;
        map = this.jdbcTemplate.queryForMap(this.selectMinMaxId, new Object[]{appGrpKey});
        long minId = 0L;
        long maxId = 0L;
        int appGrpId = this.pushInfoServiceImpl.getAppGrpIdByAppGrpKey(appGrpKey);
        if (map.get("MIN_ID") != null) {
            minId = Long.parseLong(map.get("MIN_ID").toString());
            maxId = Long.parseLong(map.get("MAX_ID").toString());
        }
        if (log.isDebugEnabled()) {
            log.debug("min :{}, max:{}", (Object)minId, (Object)maxId);
        }
        chunkContext.getStepContext().getStepExecution().getJobExecution().getExecutionContext().putLong("min.id", minId);
        chunkContext.getStepContext().getStepExecution().getJobExecution().getExecutionContext().putLong("max.id", maxId);
        chunkContext.getStepContext().getStepExecution().getJobExecution().getExecutionContext().putLong("app.grp.id", (long)appGrpId);
        return RepeatStatus.FINISHED;
    }

    public void setSelectMinMaxId(String selectMinMaxId) {
        this.selectMinMaxId = selectMinMaxId;
    }
}

