/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.batch.job.tasklet;

import com.humuson.tms.constrants.OptmzTargetType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.repeat.RepeatStatus;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;

public class InitOptmzManualChannelTasklet
implements Tasklet,
StepExecutionListener {
    private static final Logger log = LoggerFactory.getLogger(InitOptmzManualChannelTasklet.class);
    private StepExecution stepExecution;
    private String deleteSendList;
    private String updateOptmzManualChannelInfo;
    private String fromClause;
    private String defaultWhereClause;
    private String successWhereClause;
    private String failWhereClause;
    private String openWhereClause;
    private String notOpenWhereClause;
    private String clickWhereClause;
    private String notClickWhereClause;
    @Autowired
    private JdbcTemplate jdbcTemplate;

    public RepeatStatus execute(StepContribution contribution, ChunkContext chunkContext) throws Exception {
        String postId = this.stepExecution.getJobParameters().getString("post.id");
        String optmzTargetType = this.stepExecution.getJobParameters().getString("optmz.target.type");
        ExecutionContext executionContext = this.stepExecution.getJobExecution().getExecutionContext();
        int count = 0;
        int totalDeleteCount = 0;
        do {
            count = this.jdbcTemplate.update(this.deleteSendList, new Object[]{postId});
            log.info("prev target date remove...[delete count:{}]", (Object)(totalDeleteCount += count), (Object)count);
        } while (count > 0);
        this.jdbcTemplate.update(this.updateOptmzManualChannelInfo, new Object[]{postId});
        StringBuilder fromClauseBuilder = new StringBuilder();
        StringBuilder whereClauseBuilder = new StringBuilder();
        whereClauseBuilder.append(this.defaultWhereClause);
        fromClauseBuilder.append(this.fromClause);
        if (OptmzTargetType.SUCCESS.getCode().equals(optmzTargetType)) {
            whereClauseBuilder.append(this.successWhereClause);
        } else if (OptmzTargetType.FAIL.getCode().equals(optmzTargetType)) {
            whereClauseBuilder.append(this.failWhereClause);
        } else if (OptmzTargetType.OPEN.getCode().equals(optmzTargetType)) {
            whereClauseBuilder.append(this.openWhereClause);
        } else if (OptmzTargetType.NOT_OPEN.getCode().equals(optmzTargetType)) {
            whereClauseBuilder.append(this.notOpenWhereClause);
        } else if (OptmzTargetType.NOT_CLICK.getCode().equals(optmzTargetType)) {
            whereClauseBuilder.append(this.openWhereClause);
            whereClauseBuilder.append(this.notClickWhereClause);
        } else if (OptmzTargetType.CLICK.getCode().equals(optmzTargetType)) {
            whereClauseBuilder.append(this.clickWhereClause);
        }
        executionContext.put("f.clause", (Object)fromClauseBuilder.toString());
        executionContext.put("w.clause", (Object)whereClauseBuilder.toString());
        log.info("jobExecutionContext [{}]", (Object)this.stepExecution.getJobExecution().getExecutionContext().toString());
        return RepeatStatus.FINISHED;
    }

    public void beforeStep(StepExecution stepExecution) {
        this.stepExecution = stepExecution;
    }

    public ExitStatus afterStep(StepExecution stepExecution) {
        return stepExecution.getExitStatus();
    }

    public void setDeleteSendList(String deleteSendList) {
        this.deleteSendList = deleteSendList;
    }

    public void setUpdateOptmzManualChannelInfo(String updateOptmzManualChannelInfo) {
        this.updateOptmzManualChannelInfo = updateOptmzManualChannelInfo;
    }

    public void setFromClause(String fromClause) {
        this.fromClause = fromClause;
    }

    public void setDefaultWhereClause(String defaultWhereClause) {
        this.defaultWhereClause = defaultWhereClause;
    }

    public void setSuccessWhereClause(String successWhereClause) {
        this.successWhereClause = successWhereClause;
    }

    public void setFailWhereClause(String failWhereClause) {
        this.failWhereClause = failWhereClause;
    }

    public void setOpenWhereClause(String openWhereClause) {
        this.openWhereClause = openWhereClause;
    }

    public void setNotOpenWhereClause(String notOpenWhereClause) {
        this.notOpenWhereClause = notOpenWhereClause;
    }

    public void setClickWhereClause(String clickWhereClause) {
        this.clickWhereClause = clickWhereClause;
    }

    public void setNotClickWhereClause(String notClickWhereClause) {
        this.notClickWhereClause = notClickWhereClause;
    }
}

