/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.batch.job.tasklet;

import com.humuson.tms.batch.domain.FatigueFilterSchedule;
import com.humuson.tms.batch.service.impl.FatigueFilterScheduleStatusUpdateService;
import com.humuson.tms.constrants.CommonType;
import com.humuson.tms.constrants.StatusType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.repeat.RepeatStatus;
import org.springframework.beans.factory.annotation.Autowired;

public class FatigueFilteredSchdlStatusUpdateTasklet
implements Tasklet {
    private static final Logger log = LoggerFactory.getLogger(FatigueFilteredSchdlStatusUpdateTasklet.class);
    @Autowired
    FatigueFilterScheduleStatusUpdateService fatigueFilterScheduleStatusUpdateService;

    public RepeatStatus execute(StepContribution contribution, ChunkContext chunkContext) throws Exception {
        JobParameters jobParameters = chunkContext.getStepContext().getStepExecution().getJobParameters();
        String sendType = jobParameters.getString("send.type");
        FatigueFilterSchedule schedule = new FatigueFilterSchedule();
        schedule.setSendType(sendType);
        schedule.setPostId(jobParameters.getString("post.id"));
        schedule.setServerId(jobParameters.getString("server.id"));
        if (CommonType.MASS.getCode().equals(sendType)) {
            schedule.setJobStatus(StatusType.FATIGUE_FILTER_COMPLETE.getCode());
        } else {
            schedule.setJobStatus(StatusType.RESERVE.getCode());
        }
        this.fatigueFilterScheduleStatusUpdateService.updateSchdlStatus(schedule);
        return RepeatStatus.FINISHED;
    }
}

