/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.batch.job.tasklet;

import com.humuson.tms.batch.domain.FatigueFilterSchedule;
import com.humuson.tms.batch.domain.SiteFatigueSettingInfo;
import com.humuson.tms.constrants.CommonType;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.repeat.RepeatStatus;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.NamedParameterUtils;

public class FatigueConditionCheckTasklet
implements Tasklet,
StepExecutionListener {
    private static final Logger log = LoggerFactory.getLogger(FatigueConditionCheckTasklet.class);
    private static final String UNDER_BAR = "_";
    private static final String REPLACE_ORACLE_INDEX_NAME = "@@INDEXNAME@@";
    private StepExecution stepExecution;
    private String upsertFatigueInfoSql;
    private String selectSiteFatigueFilterCntSql;
    private String upsertCampFatigueInfoSql;
    private String upsertAutoFatigueInfoSql;
    private String fatigueSendListSql;
    private String fatigueCampSendListSql;
    private String fatigueAutoSendListSql;
    @Value(value="#{dbConfig['tms.jdbc.type']}")
    protected String dbType;
    @Autowired
    private NamedParameterJdbcTemplate namedParameterJdbcTemplate;

    public RepeatStatus execute(StepContribution contribution, ChunkContext chunkContext) throws Exception {
        JobParameters jobParameters = chunkContext.getStepContext().getStepExecution().getJobParameters();
        log.debug("execute()... JobParameters: {}", (Object)jobParameters);
        FatigueFilterSchedule schedule = new FatigueFilterSchedule();
        schedule.setSiteId(Integer.parseInt(jobParameters.getString("site.id")));
        schedule.setWorkday(jobParameters.getString("workday"));
        schedule.setChnType(jobParameters.getString("chn.type"));
        schedule.setServerId(jobParameters.getString("server.id"));
        LinkedList sqlParameterList = new LinkedList();
        MapSqlParameterSource mapSqlParameterSource = new MapSqlParameterSource();
        String postId = jobParameters.getString("post.id");
        String sendType = jobParameters.getString("send.type");
        SiteFatigueSettingInfo filterCnt = this.getFilterCnt();
        if (CommonType.MASS.getCode().equals(sendType)) {
            schedule.setPostId(postId);
            this.upsertFatigueInfoSql = this.upsertCampFatigueInfoSql;
            this.fatigueSendListSql = this.fatigueCampSendListSql;
        } else {
            String[] workdayAndSeqno = postId.split(UNDER_BAR);
            if (workdayAndSeqno.length < 2) {
                throw new Exception("Wrong Format AUTO SEND POST_ID.");
            }
            String workday = workdayAndSeqno[0];
            int seqno = Integer.parseInt(workdayAndSeqno[1]);
            schedule.setWorkday(workday);
            schedule.setSeqno(seqno);
            this.upsertFatigueInfoSql = this.upsertAutoFatigueInfoSql;
            this.fatigueSendListSql = this.fatigueAutoSendListSql;
        }
        mapSqlParameterSource.addValue("dayLimit", (Object)filterCnt.getDayLimit(), 4);
        mapSqlParameterSource.addValue("monthLimit", (Object)filterCnt.getMonthLimit(), 4);
        mapSqlParameterSource.addValue("siteId", (Object)schedule.getSiteId(), 4);
        mapSqlParameterSource.addValue("postId", (Object)postId, 12);
        mapSqlParameterSource.addValue("workday", (Object)schedule.getWorkday(), 12);
        mapSqlParameterSource.addValue("seqno", (Object)schedule.getSeqno(), 4);
        mapSqlParameterSource.addValue("channelType", (Object)schedule.getChnType(), 12);
        mapSqlParameterSource.addValue("serverId", (Object)schedule.getServerId(), 12);
        if ("ORACLE".equalsIgnoreCase(this.dbType)) {
            this.fatigueSendListSql = this.fatigueSendListSql.replace(REPLACE_ORACLE_INDEX_NAME, jobParameters.getString("send.list.table").replace("TMS", "PK"));
            this.upsertFatigueInfoSql = this.upsertFatigueInfoSql.replace(REPLACE_ORACLE_INDEX_NAME, jobParameters.getString("send.list.table").replace("TMS", "PK"));
        }
        List<Object> parameterArrayList = Arrays.asList(NamedParameterUtils.buildValueArray((String)this.fatigueSendListSql, (Map)mapSqlParameterSource.getValues()));
        this.fatigueSendListSql = NamedParameterUtils.parseSqlStatementIntoString((String)this.fatigueSendListSql);
        this.stepExecution.getJobExecution().getExecutionContext().put("fatigue.send.list.sql", (Object)this.fatigueSendListSql);
        this.stepExecution.getJobExecution().getExecutionContext().put("fatigue.send.list.parameters", parameterArrayList);
        log.debug("execute()... fatigueSendListSql: {}", (Object)this.fatigueSendListSql);
        log.debug("execute()... upsertFatigueInfoSql: {}", (Object)this.upsertFatigueInfoSql);
        return RepeatStatus.FINISHED;
    }

    public void beforeStep(StepExecution _stepExecution) {
        this.stepExecution = _stepExecution;
    }

    public SiteFatigueSettingInfo getFilterCnt() {
        return (SiteFatigueSettingInfo)this.namedParameterJdbcTemplate.query(this.selectSiteFatigueFilterCntSql, (RowMapper)new RowMapper<SiteFatigueSettingInfo>(){

            public SiteFatigueSettingInfo mapRow(ResultSet rs, int rowNum) throws SQLException {
                SiteFatigueSettingInfo info = new SiteFatigueSettingInfo();
                info.setDayLimit(rs.getInt("FATIGUE_DAY_LIMIT"));
                info.setMonthLimit(rs.getInt("FATIGUE_MONTH_LIMIT"));
                return info;
            }
        }).get(0);
    }

    public ExitStatus afterStep(StepExecution stepExecution) {
        return stepExecution.getExitStatus();
    }

    public void setSelectSiteFatigueFilterCntSql(String selectSiteFatigueFilterCntSql) {
        this.selectSiteFatigueFilterCntSql = selectSiteFatigueFilterCntSql;
    }

    public void setUpsertCampFatigueInfoSql(String upsertCampFatigueInfoSql) {
        this.upsertCampFatigueInfoSql = upsertCampFatigueInfoSql;
    }

    public void setUpsertAutoFatigueInfoSql(String upsertAutoFatigueInfoSql) {
        this.upsertAutoFatigueInfoSql = upsertAutoFatigueInfoSql;
    }

    public void setFatigueCampSendListSql(String fatigueCampSendListSql) {
        this.fatigueCampSendListSql = fatigueCampSendListSql;
    }

    public void setFatigueAutoSendListSql(String fatigueAutoSendListSql) {
        this.fatigueAutoSendListSql = fatigueAutoSendListSql;
    }
}

