/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.batch.job.tasklet;

import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.repeat.RepeatStatus;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;

public class DeleteTempTasklet
implements Tasklet {
    private static final Logger log = LoggerFactory.getLogger(DeleteTempTasklet.class);
    @Autowired
    private NamedParameterJdbcTemplate namedParameterJdbcTemplate;
    private String deleteTempSendList;

    public RepeatStatus execute(StepContribution stepContribution, ChunkContext chunkContext) throws Exception {
        JobParameters jobParameters = chunkContext.getStepContext().getStepExecution().getJobParameters();
        try {
            log.info("[DeleteTempTasklet] Delete TempTargetlist START");
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("msgId", jobParameters.getString("msg.id"));
            int res = this.namedParameterJdbcTemplate.update(this.deleteTempSendList, paramMap);
            log.info("[DeleteTempTasklet] SUCCESS msgId : {}, DelCnt : {}, ", (Object)jobParameters.getString("msg.id"), (Object)res);
        }
        catch (Exception e) {
            log.error("[DeleteTempTasklet] Exception : {} ", (Object)e.getMessage());
        }
        return RepeatStatus.FINISHED;
    }

    public void setDeleteTempSendList(String deleteTempSendList) {
        this.deleteTempSendList = deleteTempSendList;
    }
}

