/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.batch.job.tasklet;

import java.util.Calendar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.repeat.RepeatStatus;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;

public class DeleteTargetErrorListTasklet
implements Tasklet {
    private static final Logger log = LoggerFactory.getLogger(DeleteTargetErrorListTasklet.class);
    @Autowired
    private JdbcTemplate jdbcTemplate;
    private String truncateFatigueListSql;
    private final String PARTITION_NAME = "@@PARTITION_NAME@@";
    private final String PARTITION_PREFIX_NAME = "P_TARGET_ERROR_";

    public RepeatStatus execute(StepContribution stepContribution, ChunkContext chunkContext) throws Exception {
        Calendar cal = Calendar.getInstance();
        int year = cal.get(1);
        int month = cal.get(2) + 1;
        String yearMonth = null;
        if (month == 1) {
            --year;
            month = 12;
        } else {
            --month;
        }
        yearMonth = month < 10 ? year + "0" + month : year + "" + month;
        try {
            log.info("Truncate fatigue list start");
            this.truncateFatigueListSql = this.truncateFatigueListSql.replace("@@PARTITION_NAME@@", "P_TARGET_ERROR_" + yearMonth);
            int count = this.jdbcTemplate.update(this.truncateFatigueListSql);
            log.info("Truncate Success Partition Table : {} Partition Name : {}", (Object)"TMS_TARGET_ERROR_LIST", (Object)("P_TARGET_ERROR_" + yearMonth));
            log.info("Truncate fatigue list end");
        }
        catch (Exception e) {
            log.error("delete fatigue list error", (Throwable)e);
        }
        return RepeatStatus.FINISHED;
    }

    public void setTruncateFatigueListSql(String truncateFatigueListSql) {
        this.truncateFatigueListSql = truncateFatigueListSql;
    }
}

